/*
 * Decompiled with CFR 0.152.
 */
package com.xuxueli.poi.excel;

import com.xuxueli.poi.excel.annotation.ExcelField;
import com.xuxueli.poi.excel.annotation.ExcelSheet;
import com.xuxueli.poi.excel.util.FieldReflectionUtil;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExportUtil {
    private static Logger logger = LoggerFactory.getLogger(ExcelExportUtil.class);

    public static Workbook exportWorkbook(List<?> ... dataListArr) {
        if (dataListArr == null || dataListArr.length == 0) {
            throw new RuntimeException(">>>>>>>>>>> xxl-excel error, data array can not be empty.");
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        for (List<?> dataList : dataListArr) {
            ExcelExportUtil.makeSheet((Workbook)workbook, dataList);
        }
        return workbook;
    }

    private static void makeSheet(Workbook workbook, List<?> dataList) {
        int i;
        Sheet existSheet;
        if (dataList == null || dataList.size() == 0) {
            throw new RuntimeException(">>>>>>>>>>> xxl-excel error, data can not be empty.");
        }
        Class<?> sheetClass = dataList.get(0).getClass();
        ExcelSheet excelSheet = sheetClass.getAnnotation(ExcelSheet.class);
        String sheetName = dataList.get(0).getClass().getSimpleName();
        HSSFColor.HSSFColorPredefined headColor = null;
        if (excelSheet != null) {
            if (excelSheet.name() != null && excelSheet.name().trim().length() > 0) {
                sheetName = excelSheet.name().trim();
            }
            headColor = excelSheet.headColor();
        }
        if ((existSheet = workbook.getSheet(sheetName)) != null) {
            for (int i2 = 2; i2 <= 1000; ++i2) {
                String newSheetName = sheetName.concat(String.valueOf(i2));
                existSheet = workbook.getSheet(newSheetName);
                if (existSheet != null) continue;
                sheetName = newSheetName;
                break;
            }
        }
        Sheet sheet = workbook.createSheet(sheetName);
        ArrayList<Field> fields = new ArrayList<Field>();
        if (sheetClass.getDeclaredFields() != null && sheetClass.getDeclaredFields().length > 0) {
            for (Field field : sheetClass.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                fields.add(field);
            }
        }
        if (fields == null || fields.size() == 0) {
            throw new RuntimeException(">>>>>>>>>>> xxl-excel error, data field can not be empty.");
        }
        CellStyle headStyle = null;
        if (headColor != null) {
            headStyle = workbook.createCellStyle();
            headStyle.setFillForegroundColor(headColor.getIndex());
            headStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            headStyle.setFillBackgroundColor(headColor.getIndex());
        }
        Row headRow = sheet.createRow(0);
        boolean ifSetWidth = false;
        for (i = 0; i < fields.size(); ++i) {
            Field field = (Field)fields.get(i);
            ExcelField excelField = field.getAnnotation(ExcelField.class);
            String fieldName = excelField != null && excelField.name() != null && excelField.name().trim().length() > 0 ? excelField.name() : field.getName();
            int fieldWidth = excelField != null ? excelField.width() : 0;
            Cell cellX = headRow.createCell(i, CellType.STRING);
            if (headStyle != null) {
                cellX.setCellStyle(headStyle);
            }
            if (fieldWidth > 0) {
                sheet.setColumnWidth(i, fieldWidth);
                ifSetWidth = true;
            }
            cellX.setCellValue(String.valueOf(fieldName));
        }
        for (int dataIndex = 0; dataIndex < dataList.size(); ++dataIndex) {
            int rowIndex = dataIndex + 1;
            Object rowData = dataList.get(dataIndex);
            Row rowX = sheet.createRow(rowIndex);
            for (int i3 = 0; i3 < fields.size(); ++i3) {
                Field field = (Field)fields.get(i3);
                try {
                    field.setAccessible(true);
                    Object fieldValue = field.get(rowData);
                    String fieldValueString = FieldReflectionUtil.formatValue(field, fieldValue);
                    Cell cellX = rowX.createCell(i3, CellType.STRING);
                    cellX.setCellValue(fieldValueString);
                    continue;
                }
                catch (IllegalAccessException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }
        if (!ifSetWidth) {
            for (i = 0; i < fields.size(); ++i) {
                sheet.autoSizeColumn((int)((short)i));
            }
        }
    }

    public static void exportToFile(String filePath, List<?> ... dataList) {
        Workbook workbook = ExcelExportUtil.exportWorkbook(dataList);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(filePath);
            workbook.write((OutputStream)fileOutputStream);
            fileOutputStream.flush();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public static byte[] exportToBytes(List<?> ... dataList) {
        Workbook workbook = ExcelExportUtil.exportWorkbook(dataList);
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] result = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byte[] byArray = result = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

