/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class DiskUtil {
    static final String BASE_DIR = File.separator + "data" + File.separator + "config-data";
    static final String TENANT_BASE_DIR = File.separator + "data" + File.separator + "tenant-config-data";
    static final String BETA_DIR = File.separator + "data" + File.separator + "beta-data";
    static final String TENANT_BETA_DIR = File.separator + "data" + File.separator + "tenant-beta-data";
    static final String TAG_DIR = File.separator + "data" + File.separator + "tag-data";
    static final String TENANT_TAG_DIR = File.separator + "data" + File.separator + "tag-beta-data";

    public static void saveHeartBeatToDisk(String heartBeatTime) throws IOException {
        FileUtils.writeStringToFile((File)DiskUtil.heartBeatFile(), (String)heartBeatTime, (String)"UTF-8");
    }

    public static void saveToDisk(String dataId, String group, String tenant, String content) throws IOException {
        File targetFile = DiskUtil.targetFile(dataId, group, tenant);
        FileUtils.writeStringToFile((File)targetFile, (String)content, (String)"UTF-8");
    }

    public static void saveBetaToDisk(String dataId, String group, String tenant, String content) throws IOException {
        File targetFile = DiskUtil.targetBetaFile(dataId, group, tenant);
        FileUtils.writeStringToFile((File)targetFile, (String)content, (String)"UTF-8");
    }

    public static void saveTagToDisk(String dataId, String group, String tenant, String tag, String content) throws IOException {
        File targetFile = DiskUtil.targetTagFile(dataId, group, tenant, tag);
        FileUtils.writeStringToFile((File)targetFile, (String)content, (String)"UTF-8");
    }

    public static void removeConfigInfo(String dataId, String group, String tenant) {
        FileUtils.deleteQuietly((File)DiskUtil.targetFile(dataId, group, tenant));
    }

    public static void removeConfigInfo4Beta(String dataId, String group, String tenant) {
        FileUtils.deleteQuietly((File)DiskUtil.targetBetaFile(dataId, group, tenant));
    }

    public static void removeConfigInfo4Tag(String dataId, String group, String tenant, String tag) {
        FileUtils.deleteQuietly((File)DiskUtil.targetTagFile(dataId, group, tenant, tag));
    }

    public static void removeHeartHeat() {
        FileUtils.deleteQuietly((File)DiskUtil.heartBeatFile());
    }

    public static File targetFile(String dataId, String group, String tenant) {
        File file;
        if (StringUtils.isBlank((CharSequence)tenant)) {
            file = new File(EnvUtil.getNacosHome(), BASE_DIR);
        } else {
            file = new File(EnvUtil.getNacosHome(), TENANT_BASE_DIR);
            file = new File(file, tenant);
        }
        file = new File(file, group);
        file = new File(file, dataId);
        return file;
    }

    public static File targetBetaFile(String dataId, String group, String tenant) {
        File file;
        if (StringUtils.isBlank((CharSequence)tenant)) {
            file = new File(EnvUtil.getNacosHome(), BETA_DIR);
        } else {
            file = new File(EnvUtil.getNacosHome(), TENANT_BETA_DIR);
            file = new File(file, tenant);
        }
        file = new File(file, group);
        file = new File(file, dataId);
        return file;
    }

    public static File targetTagFile(String dataId, String group, String tenant, String tag) {
        File file;
        if (StringUtils.isBlank((CharSequence)tenant)) {
            file = new File(EnvUtil.getNacosHome(), TAG_DIR);
        } else {
            file = new File(EnvUtil.getNacosHome(), TENANT_TAG_DIR);
            file = new File(file, tenant);
        }
        file = new File(file, group);
        file = new File(file, dataId);
        file = new File(file, tag);
        return file;
    }

    public static String getConfig(String dataId, String group, String tenant) throws IOException {
        File file = DiskUtil.targetFile(dataId, group, tenant);
        if (file.exists()) {
            String string;
            FileInputStream fis = new FileInputStream(file);
            try {
                string = IoUtils.toString((InputStream)fis, (String)"UTF-8");
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    return "";
                }
            }
            fis.close();
            return string;
        }
        return "";
    }

    public static String getLocalConfigMd5(String dataId, String group, String tenant) throws IOException {
        return MD5Utils.md5Hex((String)DiskUtil.getConfig(dataId, group, tenant), (String)"UTF-8");
    }

    public static File heartBeatFile() {
        return new File(EnvUtil.getNacosHome(), "status" + File.separator + "heartBeat.txt");
    }

    public static String relativePath(String dataId, String group) {
        return BASE_DIR + "/" + dataId + "/" + group;
    }

    public static void clearAll() {
        File file = new File(EnvUtil.getNacosHome(), BASE_DIR);
        if (FileUtils.deleteQuietly((File)file)) {
            LogUtil.DEFAULT_LOG.info("clear all config-info success.");
        } else {
            LogUtil.DEFAULT_LOG.warn("clear all config-info failed.");
        }
        File fileTenant = new File(EnvUtil.getNacosHome(), TENANT_BASE_DIR);
        if (FileUtils.deleteQuietly((File)fileTenant)) {
            LogUtil.DEFAULT_LOG.info("clear all config-info-tenant success.");
        } else {
            LogUtil.DEFAULT_LOG.warn("clear all config-info-tenant failed.");
        }
    }

    public static void clearAllBeta() {
        File file = new File(EnvUtil.getNacosHome(), BETA_DIR);
        if (FileUtils.deleteQuietly((File)file)) {
            LogUtil.DEFAULT_LOG.info("clear all config-info-beta success.");
        } else {
            LogUtil.DEFAULT_LOG.warn("clear all config-info-beta failed.");
        }
        File fileTenant = new File(EnvUtil.getNacosHome(), TENANT_BETA_DIR);
        if (FileUtils.deleteQuietly((File)fileTenant)) {
            LogUtil.DEFAULT_LOG.info("clear all config-info-beta-tenant success.");
        } else {
            LogUtil.DEFAULT_LOG.warn("clear all config-info-beta-tenant failed.");
        }
    }

    public static void clearAllTag() {
        File file = new File(EnvUtil.getNacosHome(), TAG_DIR);
        if (FileUtils.deleteQuietly((File)file)) {
            LogUtil.DEFAULT_LOG.info("clear all config-info-tag success.");
        } else {
            LogUtil.DEFAULT_LOG.warn("clear all config-info-tag failed.");
        }
        File fileTenant = new File(EnvUtil.getNacosHome(), TENANT_TAG_DIR);
        if (FileUtils.deleteQuietly((File)fileTenant)) {
            LogUtil.DEFAULT_LOG.info("clear all config-info-tag-tenant success.");
        } else {
            LogUtil.DEFAULT_LOG.warn("clear all config-info-tag-tenant failed.");
        }
    }
}

