/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.config.server.model.SampleResult;
import com.alibaba.nacos.config.server.service.notify.NotifyService;
import com.alibaba.nacos.config.server.utils.ConfigExecutor;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigSubService {
    private ServerMemberManager memberManager;

    @Autowired
    public ConfigSubService(ServerMemberManager memberManager) {
        this.memberManager = memberManager;
    }

    protected ConfigSubService() {
    }

    private String getUrl(String ip, String relativePath) {
        return "http://" + ip + EnvUtil.getContextPath() + relativePath;
    }

    private List<SampleResult> runCollectionJob(String url, Map<String, String> params, CompletionService<SampleResult> completionService, List<SampleResult> resultList) {
        Collection ipList = this.memberManager.allMembers();
        ArrayList<SampleResult> collectionResult = new ArrayList<SampleResult>(ipList.size());
        for (Member ip : ipList) {
            try {
                completionService.submit(new Job(ip.getAddress(), url, params));
            }
            catch (Exception e) {
                LogUtil.DEFAULT_LOG.warn("Get client info from {} with exception: {} during submit job", (Object)ip, (Object)e.getMessage());
            }
        }
        SampleResult sampleResults = null;
        for (Member member : ipList) {
            try {
                Future<SampleResult> f = completionService.poll(1000L, TimeUnit.MILLISECONDS);
                try {
                    if (f != null) {
                        sampleResults = f.get(500L, TimeUnit.MILLISECONDS);
                        if (sampleResults == null) continue;
                        collectionResult.add(sampleResults);
                        continue;
                    }
                    LogUtil.DEFAULT_LOG.warn("The task in ip: {}  did not completed in 1000ms ", (Object)member);
                }
                catch (TimeoutException e) {
                    if (f != null) {
                        f.cancel(true);
                    }
                    LogUtil.DEFAULT_LOG.warn("get task result with TimeoutException: {} ", (Object)e.getMessage());
                }
            }
            catch (InterruptedException e) {
                LogUtil.DEFAULT_LOG.warn("get task result with InterruptedException: {} ", (Object)e.getMessage());
            }
            catch (ExecutionException e) {
                LogUtil.DEFAULT_LOG.warn("get task result with ExecutionException: {} ", (Object)e.getMessage());
            }
        }
        return collectionResult;
    }

    public SampleResult mergeSampleResult(SampleResult sampleCollectResult, List<SampleResult> sampleResults) {
        SampleResult mergeResult = new SampleResult();
        Map<Object, Object> listenersGroupkeyStatus = null;
        listenersGroupkeyStatus = sampleCollectResult.getLisentersGroupkeyStatus() == null || sampleCollectResult.getLisentersGroupkeyStatus().isEmpty() ? new HashMap(10) : sampleCollectResult.getLisentersGroupkeyStatus();
        for (SampleResult sampleResult : sampleResults) {
            Map<String, String> listenersGroupkeyStatusTmp = sampleResult.getLisentersGroupkeyStatus();
            for (Map.Entry<String, String> entry : listenersGroupkeyStatusTmp.entrySet()) {
                listenersGroupkeyStatus.put(entry.getKey(), entry.getValue());
            }
        }
        mergeResult.setLisentersGroupkeyStatus(listenersGroupkeyStatus);
        return mergeResult;
    }

    public SampleResult getCollectSampleResult(String dataId, String group, String tenant, int sampleTime) throws Exception {
        ArrayList<SampleResult> resultList = new ArrayList<SampleResult>();
        String url = "/v1/cs/communication/configWatchers";
        HashMap<String, String> params = new HashMap<String, String>(5);
        params.put("dataId", dataId);
        params.put("group", group);
        if (!StringUtils.isBlank((CharSequence)tenant)) {
            params.put("tenant", tenant);
        }
        LinkedBlockingDeque queue = new LinkedBlockingDeque(this.memberManager.getServerList().size());
        ExecutorCompletionService<SampleResult> completionService = new ExecutorCompletionService<SampleResult>(ConfigExecutor.getConfigSubServiceExecutor(), queue);
        SampleResult sampleCollectResult = new SampleResult();
        for (int i = 0; i < sampleTime; ++i) {
            List<SampleResult> sampleResults = this.runCollectionJob(url, params, completionService, resultList);
            sampleCollectResult = this.mergeSampleResult(sampleCollectResult, sampleResults);
        }
        return sampleCollectResult;
    }

    public SampleResult getCollectSampleResultByIp(String ip, int sampleTime) throws Exception {
        ArrayList<SampleResult> resultList = new ArrayList<SampleResult>(10);
        String url = "/v1/cs/communication/watcherConfigs";
        HashMap<String, String> params = new HashMap<String, String>(50);
        params.put("ip", ip);
        LinkedBlockingDeque queue = new LinkedBlockingDeque(this.memberManager.getServerList().size());
        ExecutorCompletionService<SampleResult> completionService = new ExecutorCompletionService<SampleResult>(ConfigExecutor.getConfigSubServiceExecutor(), queue);
        SampleResult sampleCollectResult = new SampleResult();
        for (int i = 0; i < sampleTime; ++i) {
            List<SampleResult> sampleResults = this.runCollectionJob(url, params, completionService, resultList);
            sampleCollectResult = this.mergeSampleResult(sampleCollectResult, sampleResults);
        }
        return sampleCollectResult;
    }

    class Job
    implements Callable<SampleResult> {
        private String ip;
        private String url;
        private Map<String, String> params;

        public Job(String ip, String url, Map<String, String> params) {
            this.ip = ip;
            this.url = url;
            this.params = params;
        }

        @Override
        public SampleResult call() throws Exception {
            try {
                StringBuilder paramUrl = new StringBuilder();
                for (Map.Entry<String, String> param : this.params.entrySet()) {
                    paramUrl.append("&").append(param.getKey()).append("=").append(URLEncoder.encode(param.getValue(), "UTF-8"));
                }
                String urlAll = ConfigSubService.this.getUrl(this.ip, this.url) + "?" + paramUrl;
                RestResult<String> result = NotifyService.invokeURL(urlAll, null, "UTF-8");
                if (result.ok()) {
                    return (SampleResult)JacksonUtils.toObj((String)((String)result.getData()), SampleResult.class);
                }
                LogUtil.DEFAULT_LOG.info("Can not get clientInfo from {} with {}", (Object)this.ip, result.getData());
                return null;
            }
            catch (Exception e) {
                LogUtil.DEFAULT_LOG.warn("Get client info from {} with exception: {}", (Object)this.ip, (Object)e.getMessage());
                return null;
            }
        }
    }
}

