/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.config.server.model.capacity.Capacity;
import com.alibaba.nacos.config.server.service.capacity.CapacityService;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/cs/capacity"})
public class CapacityController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CapacityController.class);
    private final CapacityService capacityService;
    private static final int STATUS200 = 200;
    private static final int STATUS400 = 400;
    private static final int STATUS500 = 500;

    @Autowired
    public CapacityController(CapacityService capacityService) {
        this.capacityService = capacityService;
    }

    @GetMapping
    public RestResult<Capacity> getCapacity(HttpServletResponse response, @RequestParam(required=false) String group, @RequestParam(required=false) String tenant) {
        if (group == null && tenant == null) {
            RestResult restResult = new RestResult();
            response.setStatus(400);
            restResult.setCode(400);
            restResult.setMessage("The parameter group and tenant cannot be empty at the same time");
            return restResult;
        }
        if (group == null && StringUtils.isBlank((CharSequence)tenant)) {
            RestResult restResult = new RestResult();
            response.setStatus(400);
            restResult.setCode(400);
            restResult.setMessage("tenant cannot be an empty string");
            return restResult;
        }
        RestResult restResult = new RestResult();
        try {
            response.setStatus(200);
            restResult.setCode(200);
            Capacity capacity = this.capacityService.getCapacityWithDefault(group, tenant);
            if (capacity == null) {
                LOGGER.warn("[getCapacity] capacity not exist\uff0cneed init group: {}, tenant: {}", (Object)group, (Object)tenant);
                this.capacityService.initCapacity(group, tenant);
                capacity = this.capacityService.getCapacityWithDefault(group, tenant);
            }
            if (capacity != null) {
                restResult.setData((Object)capacity);
            }
        }
        catch (Exception e) {
            LOGGER.error("[getCapacity] ", (Throwable)e);
            response.setStatus(500);
            restResult.setCode(500);
            restResult.setMessage(e.getMessage());
        }
        return restResult;
    }

    @PostMapping
    public RestResult<Boolean> updateCapacity(HttpServletResponse response, @RequestParam(required=false) String group, @RequestParam(required=false) String tenant, @RequestParam(required=false) Integer quota, @RequestParam(required=false) Integer maxSize, @RequestParam(required=false) Integer maxAggrCount, @RequestParam(required=false) Integer maxAggrSize) {
        String targetFieldValue;
        String targetFieldName;
        if (StringUtils.isBlank((CharSequence)group) && StringUtils.isBlank((CharSequence)tenant)) {
            this.capacityService.initAllCapacity();
            RestResult restResult = new RestResult();
            this.setFailResult(response, (RestResult<Boolean>)restResult, 400);
            restResult.setMessage("The parameter group and tenant cannot be empty at the same time");
            return restResult;
        }
        if (quota == null && maxSize == null && maxAggrCount == null && maxAggrSize == null) {
            RestResult restResult = new RestResult();
            this.setFailResult(response, (RestResult<Boolean>)restResult, 400);
            restResult.setMessage("The parameters quota, maxSize, maxAggrCount, maxAggrSize cannot be empty at the same time");
            return restResult;
        }
        if (tenant == null) {
            targetFieldName = "group";
            targetFieldValue = group;
        } else {
            targetFieldName = "tenant";
            targetFieldValue = tenant;
        }
        RestResult restResult = new RestResult();
        if (StringUtils.isBlank((CharSequence)targetFieldValue)) {
            this.setFailResult(response, (RestResult<Boolean>)restResult, 400);
            restResult.setMessage(String.format("parameter %s is empty.", targetFieldName));
            return restResult;
        }
        try {
            boolean insertOrUpdateResult = this.capacityService.insertOrUpdateCapacity(group, tenant, quota, maxSize, maxAggrCount, maxAggrSize);
            if (insertOrUpdateResult) {
                this.setSuccessResult(response, (RestResult<Boolean>)restResult);
                restResult.setMessage(String.format("successfully updated the capacity information configuration of %s to %s", targetFieldName, targetFieldValue));
                return restResult;
            }
            this.setFailResult(response, (RestResult<Boolean>)restResult, 500);
            restResult.setMessage(String.format("failed updated the capacity information configuration of %s to %s", targetFieldName, targetFieldValue));
            return restResult;
        }
        catch (Exception e) {
            LOGGER.error("[updateCapacity] ", (Throwable)e);
            this.setFailResult(response, (RestResult<Boolean>)restResult, 500);
            restResult.setMessage(e.getMessage());
            return restResult;
        }
    }

    private void setFailResult(HttpServletResponse response, RestResult<Boolean> restResult, int statusCode) {
        response.setStatus(statusCode);
        restResult.setCode(statusCode);
        restResult.setData((Object)false);
    }

    private void setSuccessResult(HttpServletResponse response, RestResult<Boolean> restResult) {
        response.setStatus(200);
        restResult.setCode(200);
        restResult.setData((Object)true);
    }
}

