/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.auth;

import com.alibaba.nacos.config.server.auth.PermissionInfo;
import com.alibaba.nacos.config.server.auth.PermissionPersistService;
import com.alibaba.nacos.config.server.configuration.ConditionOnExternalStorage;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.RowMapperManager;
import com.alibaba.nacos.config.server.service.repository.extrnal.ExternalStoragePersistServiceImpl;
import com.alibaba.nacos.config.server.utils.LogUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Conditional(value={ConditionOnExternalStorage.class})
@Component
public class ExternalPermissionPersistServiceImpl
implements PermissionPersistService {
    @Autowired
    private ExternalStoragePersistServiceImpl persistService;
    private JdbcTemplate jt;

    @PostConstruct
    protected void init() {
        this.jt = this.persistService.getJdbcTemplate();
    }

    @Override
    public Page<PermissionInfo> getPermissions(String role, int pageNo, int pageSize) {
        PaginationHelper<PermissionInfo> helper = this.persistService.createPaginationHelper();
        String sqlCountRows = "select count(*) from permissions where ";
        String sqlFetchRows = "select role,resource,action from permissions where ";
        String where = " role= ? ";
        List<Object> params = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)role)) {
            params = Collections.singletonList(role);
        } else {
            where = " 1=1 ";
        }
        try {
            Page<PermissionInfo> pageInfo = helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, RowMapperManager.PERMISSION_ROW_MAPPER);
            if (pageInfo == null) {
                pageInfo = new Page();
                pageInfo.setTotalCount(0);
                pageInfo.setPageItems(new ArrayList());
            }
            return pageInfo;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void addPermission(String role, String resource, String action) {
        String sql = "INSERT into permissions (role, resource, action) VALUES (?, ?, ?)";
        try {
            this.jt.update(sql, new Object[]{role, resource, action});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void deletePermission(String role, String resource, String action) {
        String sql = "DELETE from permissions WHERE role=? and resource=? and action=?";
        try {
            this.jt.update(sql, new Object[]{role, resource, action});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }
}

