/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.auth;

import com.alibaba.nacos.config.server.auth.UserPersistService;
import com.alibaba.nacos.config.server.configuration.ConditionOnEmbeddedStorage;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.model.User;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.RowMapperManager;
import com.alibaba.nacos.config.server.service.repository.embedded.DatabaseOperate;
import com.alibaba.nacos.config.server.service.repository.embedded.EmbeddedStoragePersistServiceImpl;
import com.alibaba.nacos.config.server.service.sql.EmbeddedStorageContextUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ConditionOnEmbeddedStorage.class})
@Component
public class EmbeddedUserPersistServiceImpl
implements UserPersistService {
    @Autowired
    private DatabaseOperate databaseOperate;
    @Autowired
    private EmbeddedStoragePersistServiceImpl persistService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createUser(String username, String password) {
        String sql = "INSERT into users (username, password, enabled) VALUES (?, ?, ?)";
        try {
            EmbeddedStorageContextUtils.addSqlContext(sql, username, password, true);
            this.databaseOperate.blockUpdate();
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public void deleteUser(String username) {
        String sql = "DELETE from users WHERE username=?";
        try {
            EmbeddedStorageContextUtils.addSqlContext(sql, username);
            this.databaseOperate.blockUpdate();
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public void updateUserPassword(String username, String password) {
        try {
            EmbeddedStorageContextUtils.addSqlContext("UPDATE users SET password = ? WHERE username=?", password, username);
            this.databaseOperate.blockUpdate();
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public User findUserByUsername(String username) {
        String sql = "SELECT username,password FROM users WHERE username=? ";
        return this.databaseOperate.queryOne(sql, new Object[]{username}, RowMapperManager.USER_ROW_MAPPER);
    }

    @Override
    public Page<User> getUsers(int pageNo, int pageSize) {
        PaginationHelper<User> helper = this.persistService.createPaginationHelper();
        String sqlCountRows = "select count(*) from users where ";
        String sqlFetchRows = "select username,password from users where ";
        String where = " 1=1 ";
        Page<User> pageInfo = helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, new ArrayList().toArray(), pageNo, pageSize, RowMapperManager.USER_ROW_MAPPER);
        if (pageInfo == null) {
            pageInfo = new Page();
            pageInfo.setTotalCount(0);
            pageInfo.setPageItems(new ArrayList());
        }
        return pageInfo;
    }

    @Override
    public List<String> findUserLikeUsername(String username) {
        String sql = "SELECT username FROM users WHERE username like ? ";
        return this.databaseOperate.queryMany(sql, (Object[])new String[]{"%" + username + "%"}, String.class);
    }
}

