/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.auth;

import com.alibaba.nacos.config.server.auth.RoleInfo;
import com.alibaba.nacos.config.server.auth.RolePersistService;
import com.alibaba.nacos.config.server.configuration.ConditionOnEmbeddedStorage;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.RowMapperManager;
import com.alibaba.nacos.config.server.service.repository.embedded.DatabaseOperate;
import com.alibaba.nacos.config.server.service.repository.embedded.EmbeddedStoragePersistServiceImpl;
import com.alibaba.nacos.config.server.service.sql.EmbeddedStorageContextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ConditionOnEmbeddedStorage.class})
@Component
public class EmbeddedRolePersistServiceImpl
implements RolePersistService {
    @Autowired
    private DatabaseOperate databaseOperate;
    @Autowired
    private EmbeddedStoragePersistServiceImpl persistService;

    @Override
    public Page<RoleInfo> getRoles(int pageNo, int pageSize) {
        PaginationHelper<RoleInfo> helper = this.persistService.createPaginationHelper();
        String sqlCountRows = "select count(*) from (select distinct role from roles) roles where ";
        String sqlFetchRows = "select role,username from roles where ";
        String where = " 1=1 ";
        Page<RoleInfo> pageInfo = helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, new ArrayList().toArray(), pageNo, pageSize, RowMapperManager.ROLE_INFO_ROW_MAPPER);
        if (pageInfo == null) {
            pageInfo = new Page();
            pageInfo.setTotalCount(0);
            pageInfo.setPageItems(new ArrayList());
        }
        return pageInfo;
    }

    @Override
    public Page<RoleInfo> getRolesByUserName(String username, int pageNo, int pageSize) {
        PaginationHelper<RoleInfo> helper = this.persistService.createPaginationHelper();
        String sqlCountRows = "select count(*) from roles where ";
        String sqlFetchRows = "select role,username from roles where ";
        String where = " username= ? ";
        List<Object> params = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            params = Collections.singletonList(username);
        } else {
            where = " 1=1 ";
        }
        return helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, RowMapperManager.ROLE_INFO_ROW_MAPPER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRole(String role, String userName) {
        String sql = "INSERT into roles (role, username) VALUES (?, ?)";
        try {
            EmbeddedStorageContextUtils.addSqlContext(sql, role, userName);
            this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public void deleteRole(String role) {
        String sql = "DELETE from roles WHERE role=?";
        try {
            EmbeddedStorageContextUtils.addSqlContext(sql, role);
            this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRole(String role, String username) {
        String sql = "DELETE from roles WHERE role=? and username=?";
        try {
            EmbeddedStorageContextUtils.addSqlContext(sql, role, username);
            this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public List<String> findRolesLikeRoleName(String role) {
        String sql = "SELECT role FROM roles WHERE role like ? ";
        return this.databaseOperate.queryMany(sql, (Object[])new String[]{"%" + role + "%"}, String.class);
    }
}

