/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.excel.handler;

import com.alibaba.excel.context.AnalysisContext;
import com.pig4cloud.plugin.excel.handler.ListAnalysisEventListener;
import com.pig4cloud.plugin.excel.kit.Validators;
import com.pig4cloud.plugin.excel.vo.ErrorMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAnalysisEventListener
extends ListAnalysisEventListener<Object> {
    private static final Logger log = LoggerFactory.getLogger(DefaultAnalysisEventListener.class);
    private final List<Object> list = new ArrayList<Object>();
    private final List<ErrorMessage> errorMessageList = new ArrayList<ErrorMessage>();
    private Long lineNum = 1L;

    public void invoke(Object o, AnalysisContext analysisContext) {
        Long l = this.lineNum;
        Long l2 = this.lineNum = Long.valueOf(this.lineNum + 1L);
        Set<ConstraintViolation<Object>> violations = Validators.validate(o);
        if (!violations.isEmpty()) {
            Set<String> messageSet = violations.stream().map(ConstraintViolation::getMessage).collect(Collectors.toSet());
            this.errorMessageList.add(new ErrorMessage(this.lineNum, messageSet));
        } else {
            this.list.add(o);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
        log.debug("Excel read analysed");
    }

    @Override
    public List<Object> getList() {
        return this.list;
    }

    @Override
    public List<ErrorMessage> getErrors() {
        return this.errorMessageList;
    }
}

