/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.utility;

import com.networknt.config.Config;
import java.io.InputStream;
import java.security.KeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsUtil {
    static final Logger logger = LoggerFactory.getLogger(TlsUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore loadKeyStore(String name, char[] password) {
        try (InputStream stream = Config.getInstance().getInputStreamFromFile(name);){
            if (stream == null) {
                String message = "Unable to load keystore '" + name + "', please provide the keystore matching the configuration in client.yml/server.yml to enable TLS connection.";
                if (!logger.isErrorEnabled()) throw new RuntimeException(message);
                logger.error(message);
                throw new RuntimeException(message);
            }
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            loadedKeystore.load(stream, password);
            KeyStore keyStore = loadedKeystore;
            return keyStore;
        }
        catch (Exception e) {
            logger.error("Unable to load keystore " + name, (Throwable)e);
            throw new RuntimeException("Unable to load keystore " + name, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore loadTrustStore(String name, char[] password) {
        try (InputStream stream = Config.getInstance().getInputStreamFromFile(name);){
            if (stream == null) {
                String message = "Unable to load truststore '" + name + "', please provide the truststore matching the configuration in client.yml/server.yml to enable TLS connection.";
                if (!logger.isErrorEnabled()) throw new RuntimeException(message);
                logger.error(message);
                throw new RuntimeException(message);
            }
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            loadedKeystore.load(stream, password);
            KeyStore keyStore = loadedKeystore;
            return keyStore;
        }
        catch (Exception e) {
            logger.error("Unable to load truststore " + name, (Throwable)e);
            throw new RuntimeException("Unable to load truststore " + name, e);
        }
    }
}

