/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.AdditionalPropertiesValidator;
import com.networknt.schema.AllOfValidator;
import com.networknt.schema.AnyOfValidator;
import com.networknt.schema.ConstValidator;
import com.networknt.schema.ContainsValidator;
import com.networknt.schema.DependenciesValidator;
import com.networknt.schema.DependentRequired;
import com.networknt.schema.DependentSchemas;
import com.networknt.schema.EnumValidator;
import com.networknt.schema.ErrorMessageType;
import com.networknt.schema.ExclusiveMaximumValidator;
import com.networknt.schema.ExclusiveMinimumValidator;
import com.networknt.schema.FalseValidator;
import com.networknt.schema.I18nSupport;
import com.networknt.schema.IfValidator;
import com.networknt.schema.ItemsValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.Keyword;
import com.networknt.schema.MaxItemsValidator;
import com.networknt.schema.MaxLengthValidator;
import com.networknt.schema.MaxPropertiesValidator;
import com.networknt.schema.MaximumValidator;
import com.networknt.schema.MinItemsValidator;
import com.networknt.schema.MinLengthValidator;
import com.networknt.schema.MinPropertiesValidator;
import com.networknt.schema.MinimumValidator;
import com.networknt.schema.MultipleOfValidator;
import com.networknt.schema.NotAllowedValidator;
import com.networknt.schema.NotValidator;
import com.networknt.schema.OneOfValidator;
import com.networknt.schema.PatternPropertiesValidator;
import com.networknt.schema.PatternValidator;
import com.networknt.schema.PropertiesValidator;
import com.networknt.schema.PropertyNamesValidator;
import com.networknt.schema.ReadOnlyValidator;
import com.networknt.schema.RefValidator;
import com.networknt.schema.RequiredValidator;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.TrueValidator;
import com.networknt.schema.TypeValidator;
import com.networknt.schema.UnEvaluatedPropertiesValidator;
import com.networknt.schema.UnionTypeValidator;
import com.networknt.schema.UniqueItemsValidator;
import com.networknt.schema.ValidationContext;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum ValidatorTypeCode implements Keyword,
ErrorMessageType
{
    ADDITIONAL_PROPERTIES("additionalProperties", "1001", new MessageFormat(I18nSupport.getString("additionalProperties")), AdditionalPropertiesValidator.class, 15L),
    ALL_OF("allOf", "1002", new MessageFormat(I18nSupport.getString("allOf")), AllOfValidator.class, 15L),
    ANY_OF("anyOf", "1003", new MessageFormat(I18nSupport.getString("anyOf")), AnyOfValidator.class, 15L),
    CROSS_EDITS("crossEdits", "1004", new MessageFormat(I18nSupport.getString("crossEdits")), null, 15L),
    DEPENDENCIES("dependencies", "1007", new MessageFormat(I18nSupport.getString("dependencies")), DependenciesValidator.class, 15L),
    EDITS("edits", "1005", new MessageFormat(I18nSupport.getString("edits")), null, 15L),
    ENUM("enum", "1008", new MessageFormat(I18nSupport.getString("enum")), EnumValidator.class, 15L),
    FORMAT("format", "1009", new MessageFormat(I18nSupport.getString("format")), null, 15L){

        @Override
        public JsonValidator newValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) throws Exception {
            throw new UnsupportedOperationException("Use FormatKeyword instead");
        }
    }
    ,
    ITEMS("items", "1010", new MessageFormat(I18nSupport.getString("items")), ItemsValidator.class, 15L),
    MAXIMUM("maximum", "1011", new MessageFormat(I18nSupport.getString("maximum")), MaximumValidator.class, 15L),
    MAX_ITEMS("maxItems", "1012", new MessageFormat(I18nSupport.getString("maxItems")), MaxItemsValidator.class, 15L),
    MAX_LENGTH("maxLength", "1013", new MessageFormat(I18nSupport.getString("maxLength")), MaxLengthValidator.class, 15L),
    MAX_PROPERTIES("maxProperties", "1014", new MessageFormat(I18nSupport.getString("maxProperties")), MaxPropertiesValidator.class, 15L),
    MINIMUM("minimum", "1015", new MessageFormat(I18nSupport.getString("minimum")), MinimumValidator.class, 15L),
    MIN_ITEMS("minItems", "1016", new MessageFormat(I18nSupport.getString("minItems")), MinItemsValidator.class, 15L),
    MIN_LENGTH("minLength", "1017", new MessageFormat(I18nSupport.getString("minLength")), MinLengthValidator.class, 15L),
    MIN_PROPERTIES("minProperties", "1018", new MessageFormat(I18nSupport.getString("minProperties")), MinPropertiesValidator.class, 15L),
    MULTIPLE_OF("multipleOf", "1019", new MessageFormat(I18nSupport.getString("multipleOf")), MultipleOfValidator.class, 15L),
    NOT_ALLOWED("notAllowed", "1033", new MessageFormat(I18nSupport.getString("notAllowed")), NotAllowedValidator.class, 15L),
    NOT("not", "1020", new MessageFormat(I18nSupport.getString("not")), NotValidator.class, 15L),
    ONE_OF("oneOf", "1022", new MessageFormat(I18nSupport.getString("oneOf")), OneOfValidator.class, 15L),
    PATTERN_PROPERTIES("patternProperties", "1024", new MessageFormat(I18nSupport.getString("patternProperties")), PatternPropertiesValidator.class, 15L),
    PATTERN("pattern", "1023", new MessageFormat(I18nSupport.getString("pattern")), PatternValidator.class, 15L),
    PROPERTIES("properties", "1025", new MessageFormat(I18nSupport.getString("properties")), PropertiesValidator.class, 15L),
    READ_ONLY("readOnly", "1032", new MessageFormat(I18nSupport.getString("readOnly")), ReadOnlyValidator.class, 15L),
    REF("$ref", "1026", new MessageFormat(I18nSupport.getString("$ref")), RefValidator.class, 15L),
    REQUIRED("required", "1028", new MessageFormat(I18nSupport.getString("required")), RequiredValidator.class, 15L),
    TYPE("type", "1029", new MessageFormat(I18nSupport.getString("type")), TypeValidator.class, 15L),
    UNION_TYPE("unionType", "1030", new MessageFormat(I18nSupport.getString("unionType")), UnionTypeValidator.class, 15L),
    UNIQUE_ITEMS("uniqueItems", "1031", new MessageFormat(I18nSupport.getString("uniqueItems")), UniqueItemsValidator.class, 15L),
    DATETIME("dateTime", "1034", new MessageFormat(I18nSupport.getString("dateTime")), null, 15L),
    UUID("uuid", "1035", new MessageFormat(I18nSupport.getString("uuid")), null, 15L),
    ID("id", "1036", new MessageFormat(I18nSupport.getString("id")), null, 15L),
    IF_THEN_ELSE("if", "1037", null, IfValidator.class, 12L),
    EXCLUSIVE_MAXIMUM("exclusiveMaximum", "1038", new MessageFormat(I18nSupport.getString("exclusiveMaximum")), ExclusiveMaximumValidator.class, 14L),
    EXCLUSIVE_MINIMUM("exclusiveMinimum", "1039", new MessageFormat(I18nSupport.getString("exclusiveMinimum")), ExclusiveMinimumValidator.class, 14L),
    TRUE("true", "1040", null, TrueValidator.class, 14L),
    FALSE("false", "1041", new MessageFormat(I18nSupport.getString("false")), FalseValidator.class, 14L),
    CONST("const", "1042", new MessageFormat(I18nSupport.getString("const")), ConstValidator.class, 14L),
    CONTAINS("contains", "1043", new MessageFormat(I18nSupport.getString("contains")), ContainsValidator.class, 14L),
    PROPERTYNAMES("propertyNames", "1044", new MessageFormat(I18nSupport.getString("propertyNames")), PropertyNamesValidator.class, 14L),
    DEPENDENT_REQUIRED("dependentRequired", "1045", new MessageFormat(I18nSupport.getString("dependentRequired")), DependentRequired.class, 8L),
    DEPENDENT_SCHEMAS("dependentSchemas", "1046", new MessageFormat(I18nSupport.getString("dependentSchemas")), DependentSchemas.class, 8L),
    UNEVALUATED_PROPERTIES("unevaluatedProperties", "1047", new MessageFormat(I18nSupport.getString("unevaluatedProperties")), UnEvaluatedPropertiesValidator.class, 14L);

    private static Map<String, ValidatorTypeCode> constants;
    private static SpecVersion specVersion;
    private final String value;
    private final String errorCode;
    private final MessageFormat messageFormat;
    private String customMessage;
    private final String errorCodeKey;
    private final Class<?> validator;
    private final long versionCode;

    private ValidatorTypeCode(String value, String errorCode, MessageFormat messageFormat, Class<?> validator, long versionCode) {
        this.value = value;
        this.errorCode = errorCode;
        this.messageFormat = messageFormat;
        this.errorCodeKey = value + "ErrorCode";
        this.validator = validator;
        this.versionCode = versionCode;
        this.customMessage = null;
    }

    public static List<ValidatorTypeCode> getNonFormatKeywords(SpecVersion.VersionFlag versionFlag) {
        ArrayList<ValidatorTypeCode> result = new ArrayList<ValidatorTypeCode>();
        for (ValidatorTypeCode keyword : ValidatorTypeCode.values()) {
            if (FORMAT.equals(keyword) || !specVersion.getVersionFlags(keyword.versionCode).contains((Object)versionFlag)) continue;
            result.add(keyword);
        }
        return result;
    }

    public static ValidatorTypeCode fromValue(String value) {
        ValidatorTypeCode constant = constants.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    @Override
    public JsonValidator newValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) throws Exception {
        if (this.validator == null) {
            throw new UnsupportedOperationException("No suitable validator for " + this.getValue());
        }
        Constructor<?> c = this.validator.getConstructor(String.class, JsonNode.class, JsonSchema.class, ValidationContext.class);
        return (JsonValidator)c.newInstance(schemaPath + "/" + this.getValue(), schemaNode, parentSchema, validationContext);
    }

    public String toString() {
        return this.value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public MessageFormat getMessageFormat() {
        return this.messageFormat;
    }

    @Override
    public void setCustomMessage(String message) {
        this.customMessage = message;
    }

    @Override
    public String getCustomMessage() {
        return this.customMessage;
    }

    public String getErrorCodeKey() {
        return this.errorCodeKey;
    }

    public long getVersionCode() {
        return this.versionCode;
    }

    static {
        constants = new HashMap<String, ValidatorTypeCode>();
        specVersion = new SpecVersion();
        for (ValidatorTypeCode c : ValidatorTypeCode.values()) {
            constants.put(c.value, c);
        }
    }
}

