/*
 * Decompiled with CFR 0.152.
 */
package akka.management.cluster.bootstrap;

import akka.actor.ActorSystem;
import akka.annotation.InternalApi;
import akka.discovery.ServiceDiscovery;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.MarkerLoggingAdapter;
import akka.management.cluster.bootstrap.BootstrapLogMarker$;
import akka.management.cluster.bootstrap.ClusterBootstrap;
import akka.management.cluster.bootstrap.ClusterBootstrap$;
import akka.management.cluster.bootstrap.ClusterBootstrapSettings;
import akka.management.cluster.bootstrap.JoinDecider;
import akka.management.cluster.bootstrap.SeedNodesInformation;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005q4a\u0001D\u0007\u0002\u00025)\u0002\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\t\u0011!\u0002!\u0011!Q\u0001\n%BQ\u0001\f\u0001\u0005\u00025Bq!\r\u0001C\u0002\u0013E!\u0007\u0003\u0004:\u0001\u0001\u0006Ia\r\u0005\u0006u\u0001!\tb\u000f\u0005\u0006u\u0001!\tb\u0014\u0005\u0007=\u0002!\t!D0\t\r\u0001\u0004A\u0011A\u0007b\u0011\u0019a\u0007\u0001\"\u0001\u000e[\")\u0001\u000f\u0001C\tc\n!2+\u001a7g\u0003^\f'/\u001a&pS:$UmY5eKJT!AD\b\u0002\u0013\t|w\u000e^:ue\u0006\u0004(B\u0001\t\u0012\u0003\u001d\u0019G.^:uKJT!AE\n\u0002\u00155\fg.Y4f[\u0016tGOC\u0001\u0015\u0003\u0011\t7n[1\u0014\u0007\u00011B\u0004\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VM\u001a\t\u0003;yi\u0011!D\u0005\u0003?5\u00111BS8j]\u0012+7-\u001b3fe\u000611/_:uK6\u001c\u0001\u0001\u0005\u0002$M5\tAE\u0003\u0002&'\u0005)\u0011m\u0019;pe&\u0011q\u0005\n\u0002\f\u0003\u000e$xN]*zgR,W.\u0001\u0005tKR$\u0018N\\4t!\ti\"&\u0003\u0002,\u001b\tA2\t\\;ti\u0016\u0014(i\\8ugR\u0014\u0018\r]*fiRLgnZ:\u0002\rqJg.\u001b;?)\rqs\u0006\r\t\u0003;\u0001AQ\u0001I\u0002A\u0002\tBQ\u0001K\u0002A\u0002%\n1\u0001\\8h+\u0005\u0019\u0004C\u0001\u001b8\u001b\u0005)$B\u0001\u001c\u0014\u0003\u0015)g/\u001a8u\u0013\tATG\u0001\u000bNCJ\\WM\u001d'pO\u001eLgnZ!eCB$XM]\u0001\u0005Y><\u0007%\u0001\nd_:$\u0018m\u0019;Q_&tGo\u0015;sS:<GC\u0001\u001fH!\tiDI\u0004\u0002?\u0005B\u0011q\bG\u0007\u0002\u0001*\u0011\u0011)I\u0001\u0007yI|w\u000e\u001e \n\u0005\rC\u0012A\u0002)sK\u0012,g-\u0003\u0002F\r\n11\u000b\u001e:j]\u001eT!a\u0011\r\t\u000b!3\u0001\u0019A%\u0002\u0019\r|g\u000e^1diB{\u0017N\u001c;\u0011\t]QE\bT\u0005\u0003\u0017b\u0011a\u0001V;qY\u0016\u0014\u0004CA\fN\u0013\tq\u0005DA\u0002J]R$\"\u0001\u0010)\t\u000b!;\u0001\u0019A)\u0011\u0005I[fBA*Y\u001d\t!fK\u0004\u0002@+&\tA#\u0003\u0002X'\u0005IA-[:d_Z,'/_\u0005\u00033j\u000b\u0001cU3sm&\u001cW\rR5tG>4XM]=\u000b\u0005]\u001b\u0012B\u0001/^\u00059\u0011Vm]8mm\u0016$G+\u0019:hKRT!!\u0017.\u0002!M,GNZ\"p]R\f7\r\u001e)pS:$X#A%\u0002\u0017\r\fgNS8j]N+GN\u001a\u000b\u0004E\u0016<\u0007CA\fd\u0013\t!\u0007DA\u0004C_>dW-\u00198\t\u000b\u0019L\u0001\u0019A)\u0002\rQ\f'oZ3u\u0011\u0015A\u0017\u00021\u0001j\u0003\u0011IgNZ8\u0011\u0005uQ\u0017BA6\u000e\u0005Q\u0019V-\u001a3O_\u0012,7/\u00138g_Jl\u0017\r^5p]\u0006YQ.\u0019;dQ\u0016\u001c8+\u001a7g)\r\u0011gn\u001c\u0005\u0006M*\u0001\r!\u0015\u0005\u0006\u0011*\u0001\r!S\u0001\fQ>\u001cH/T1uG\",7\u000fF\u0002ceRDQa]\u0006A\u0002q\nA\u0001[8ti\")am\u0003a\u0001#\"\u0012\u0001A\u001e\t\u0003ojl\u0011\u0001\u001f\u0006\u0003sN\t!\"\u00198o_R\fG/[8o\u0013\tY\bPA\u0006J]R,'O\\1m\u0003BL\u0007")
@InternalApi
public abstract class SelfAwareJoinDecider
implements JoinDecider {
    private final ActorSystem system;
    private final MarkerLoggingAdapter log;

    public MarkerLoggingAdapter log() {
        return this.log;
    }

    public String contactPointString(Tuple2<String, Object> contactPoint) {
        return contactPoint.productIterator().mkString(":");
    }

    public String contactPointString(ServiceDiscovery.ResolvedTarget contactPoint) {
        return new StringBuilder(1).append(contactPoint.host()).append(":").append(contactPoint.port().getOrElse((Function0 & Serializable)() -> "0")).toString();
    }

    public Tuple2<String, Object> selfContactPoint() {
        return (Tuple2)Await$.MODULE$.result((Awaitable)((ClusterBootstrap)ClusterBootstrap$.MODULE$.apply(this.system)).selfContactPoint().map((Function1 & Serializable)uri -> new Tuple2((Object)uri.authority().host().toString(), (Object)BoxesRunTime.boxToInteger((int)uri.authority().port())), (ExecutionContext)this.system.dispatcher()), (Duration)Duration$.MODULE$.Inf());
    }

    public boolean canJoinSelf(ServiceDiscovery.ResolvedTarget target, SeedNodesInformation info) {
        boolean bl;
        Tuple2<String, Object> self = this.selfContactPoint();
        if (this.matchesSelf(target, self)) {
            bl = true;
        } else {
            if (!info.contactPoints().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)this.matchesSelf(x$1, (Tuple2<String, Object>)self)))) {
                this.log().warning(BootstrapLogMarker$.MODULE$.inProgress((Set<String>)((Set)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))), info.allSeedNodes()), "Self contact point [{}] not found in targets {}", (Object)this.contactPointString(this.selfContactPoint()), (Object)info.contactPoints().mkString(", "));
            }
            bl = false;
        }
        return bl;
    }

    public boolean matchesSelf(ServiceDiscovery.ResolvedTarget target, Tuple2<String, Object> contactPoint) {
        boolean bl;
        Tuple2<String, Object> tuple2 = contactPoint;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String host = (String)tuple2._1();
        int port = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
        Tuple2 tuple23 = tuple22;
        String host2 = (String)tuple23._1();
        int port2 = tuple23._2$mcI$sp();
        Option option = target.port();
        if (None$.MODULE$.equals(option)) {
            bl = this.hostMatches(host2, target);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            int lowestPort = BoxesRunTime.unboxToInt((Object)some.value());
            bl = this.hostMatches(host2, target) && port2 == lowestPort;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hostMatches(String host, ServiceDiscovery.ResolvedTarget target) {
        String hostWithoutBracket = host.replaceAll("[\\[\\]]", "");
        String string = host;
        String string2 = target.host();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = hostWithoutBracket;
        String string4 = target.host();
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        if (!target.address().map((Function1 & Serializable)x$3 -> x$3.getHostAddress()).contains((Object)hostWithoutBracket)) return false;
        return true;
    }

    public SelfAwareJoinDecider(ActorSystem system, ClusterBootstrapSettings settings) {
        this.system = system;
        this.log = Logging$.MODULE$.withMarker(system, this.getClass(), LogSource$.MODULE$.fromAnyClass());
    }
}

