/*
 * Decompiled with CFR 0.152.
 */
package akka.management.cluster.bootstrap;

import akka.AkkaVersion$;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.Props;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.discovery.Discovery$;
import akka.discovery.ServiceDiscovery;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.management.cluster.bootstrap.ClusterBootstrap;
import akka.management.cluster.bootstrap.ClusterBootstrap$;
import akka.management.cluster.bootstrap.ClusterBootstrap$Internal$Initializing$;
import akka.management.cluster.bootstrap.ClusterBootstrap$Internal$NotRunning$;
import akka.management.cluster.bootstrap.ClusterBootstrapSettings;
import akka.management.cluster.bootstrap.ClusterBootstrapSettings$;
import akka.management.cluster.bootstrap.JoinDecider;
import akka.management.cluster.bootstrap.contactpoint.HttpClusterBootstrapRoutes;
import akka.management.cluster.bootstrap.internal.BootstrapCoordinator;
import akka.management.cluster.bootstrap.internal.BootstrapCoordinator$;
import akka.management.scaladsl.AkkaManagement;
import akka.management.scaladsl.AkkaManagement$;
import akka.management.scaladsl.ManagementRouteProvider;
import akka.management.scaladsl.ManagementRouteProviderSettings;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\tEd\u0001B\u001b7\u0005}B\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ya\u0015\u0005\u0006-\u0002!\ta\u0016\u0005\b9\u0002\u0011\r\u0011\"\u0003^\u0011\u0019!\u0007\u0001)A\u0005=\"9Q\r\u0001b\u0001\n\u001b1\u0007bBAd\u0001\u0001\u0006ia\u001a\u0005\n\u0003\u0013\u0004!\u0019!C\u0001\u0003\u0017D\u0001\"a5\u0001A\u0003%\u0011Q\u001a\u0005\u000b\u0003+\u0004\u0001R1A\u0005\u0002\u0005]\u0007\"CAr\u0001\t\u0007I\u0011BAs\u0011!\ti\u000f\u0001Q\u0001\n\u0005\u001d\b\u0002CAx\u0001\u0001\u0006I!!=\t\u0013\t5\u0001A1A\u0005\n\t=\u0001\u0002\u0003B\t\u0001\u0001\u0006I!!'\t\u000f\tM\u0001\u0001\"\u0011\u0003\u0016!9!\u0011\t\u0001\u0005\u0002\t\r\u0003\u0002\u0003B&\u0001\u0011\u0005aGa\u0011\t\u0011\tm\u0003\u0001\"\u0001=\u0005;B\u0001B!\u001a\u0001\t\u0003a$qM\u0004\u0006mZB\ta\u001e\u0004\u0006kYB\t\u0001\u001f\u0005\u0006-V!\ta \u0005\b\u0003\u0003)B\u0011IA\u0002\u0011\u001d\t)!\u0006C!\u0003\u000fAq!!\u0002\u0016\t\u0003\n\t\u0002C\u0004\u0002\u001cU!\t%!\b\b\u0011\u0005\u0005R\u0003#\u00017\u0003G1\u0001\"a\n\u0016\u0011\u00031\u0014\u0011\u0006\u0005\u0007-r!\t!a\u000b\u0007\u0013\u00055B\u0004%A\u0012\"\u0005=raBAb9!\u0005\u0015\u0011\u0018\u0004\b\u0003gc\u0002\u0012QA[\u0011\u00191\u0006\u0005\"\u0001\u00028\"I\u0011Q\f\u0011\u0002\u0002\u0013\u0005\u0013q\f\u0005\n\u0003[\u0002\u0013\u0011!C\u0001\u0003_B\u0011\"a\u001e!\u0003\u0003%\t!a/\t\u0013\u0005\u0015\u0005%!A\u0005B\u0005\u001d\u0005\"CAKA\u0005\u0005I\u0011AA`\u0011%\t\t\u000bIA\u0001\n\u0003\n\u0019\u000bC\u0005\u0002&\u0002\n\t\u0011\"\u0011\u0002(\"I\u0011\u0011\u0016\u0011\u0002\u0002\u0013%\u00111V\u0004\b\u0003\u000bd\u0002\u0012QA.\r\u001d\t\u0019\u0004\bEA\u0003kAaAV\u0016\u0005\u0002\u0005e\u0003\"CA/W\u0005\u0005I\u0011IA0\u0011%\tigKA\u0001\n\u0003\ty\u0007C\u0005\u0002x-\n\t\u0011\"\u0001\u0002z!I\u0011QQ\u0016\u0002\u0002\u0013\u0005\u0013q\u0011\u0005\n\u0003+[\u0013\u0011!C\u0001\u0003/C\u0011\"!),\u0003\u0003%\t%a)\t\u0013\u0005\u00156&!A\u0005B\u0005\u001d\u0006\"CAUW\u0005\u0005I\u0011BAV\u0005A\u0019E.^:uKJ\u0014un\u001c;tiJ\f\u0007O\u0003\u00028q\u0005I!m\\8ugR\u0014\u0018\r\u001d\u0006\u0003si\nqa\u00197vgR,'O\u0003\u0002<y\u0005QQ.\u00198bO\u0016lWM\u001c;\u000b\u0003u\nA!Y6lC\u000e\u00011\u0003\u0002\u0001A\r2\u0003\"!\u0011#\u000e\u0003\tS\u0011aQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000b\n\u0013a!\u00118z%\u00164\u0007CA$K\u001b\u0005A%BA%=\u0003\u0015\t7\r^8s\u0013\tY\u0005JA\u0005FqR,gn]5p]B\u0011Q\nU\u0007\u0002\u001d*\u0011qJO\u0001\tg\u000e\fG.\u00193tY&\u0011\u0011K\u0014\u0002\u0018\u001b\u0006t\u0017mZ3nK:$(k\\;uKB\u0013xN^5eKJ\faa]=ti\u0016l\u0007CA$U\u0013\t)\u0006JA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W.\u0001\u0004=S:LGO\u0010\u000b\u00021R\u0011\u0011l\u0017\t\u00035\u0002i\u0011A\u000e\u0005\u0006%\n\u0001\u001daU\u0001\u0004Y><W#\u00010\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005d\u0014!B3wK:$\u0018BA2a\u00059aunZ4j]\u001e\fE-\u00199uKJ\fA\u0001\\8hA\u0005i!m\\8ugR\u0014\u0018\r]*uKB,\u0012a\u001a\t\u0004QF\u001cX\"A5\u000b\u0005)\\\u0017AB1u_6L7M\u0003\u0002m[\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u00059|\u0017\u0001B;uS2T\u0011\u0001]\u0001\u0005U\u00064\u0018-\u0003\u0002sS\ny\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0002u=9\u0011Qo\u0007\b\u00035R\t\u0001c\u00117vgR,'OQ8piN$(/\u00199\u0011\u0005i+2\u0003B\u000bAsr\u00042a\u0012>Z\u0013\tY\bJA\u0006FqR,gn]5p]&#\u0007CA$~\u0013\tq\bJA\nFqR,gn]5p]&#\u0007K]8wS\u0012,'\u000fF\u0001x\u0003\u0019awn\\6vaV\tQ/A\u0002hKR$2!WA\u0005\u0011\u0019\u0011\u0006\u00041\u0001\u0002\fA\u0019q)!\u0004\n\u0007\u0005=\u0001JA\u0006BGR|'oU=ti\u0016lGcA-\u0002\u0014!1!+\u0007a\u0001\u0003+\u00012aRA\f\u0013\r\tI\u0002\u0013\u0002\u001b\u00072\f7o]5d\u0003\u000e$xN]*zgR,W\u000e\u0015:pm&$WM]\u0001\u0010GJ,\u0017\r^3FqR,gn]5p]R\u0019\u0011,a\b\t\u000bIS\u0002\u0019A*\u0002\u0011%sG/\u001a:oC2\u00042!!\n\u001d\u001b\u0005)\"\u0001C%oi\u0016\u0014h.\u00197\u0014\u0005q\u0001ECAA\u0012\u00055\u0011un\u001c;tiJ\f\u0007o\u0015;faN\u0011a\u0004Q\u0015\u0004=-\u0002#\u0001D%oSRL\u0017\r\\5{S:<7\u0003C\u0016A\u0003o\tY$!\u0011\u0011\u0007\u0005eb$D\u0001\u001d!\r\t\u0015QH\u0005\u0004\u0003\u007f\u0011%a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003\u0007\n\u0019F\u0004\u0003\u0002F\u0005=c\u0002BA$\u0003\u001bj!!!\u0013\u000b\u0007\u0005-c(\u0001\u0004=e>|GOP\u0005\u0002\u0007&\u0019\u0011\u0011\u000b\"\u0002\u000fA\f7m[1hK&!\u0011QKA,\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\t\tF\u0011\u000b\u0003\u00037\u00022!!\u000f,\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\r\t\u0005\u0003G\nI'\u0004\u0002\u0002f)\u0019\u0011qM8\u0002\t1\fgnZ\u0005\u0005\u0003W\n)G\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003c\u00022!QA:\u0013\r\t)H\u0011\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003w\n\t\tE\u0002B\u0003{J1!a C\u0005\r\te.\u001f\u0005\n\u0003\u0007{\u0013\u0011!a\u0001\u0003c\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAE!\u0019\tY)!%\u0002|5\u0011\u0011Q\u0012\u0006\u0004\u0003\u001f\u0013\u0015AC2pY2,7\r^5p]&!\u00111SAG\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005e\u0015q\u0014\t\u0004\u0003\u0006m\u0015bAAO\u0005\n9!i\\8mK\u0006t\u0007\"CABc\u0005\u0005\t\u0019AA>\u0003!A\u0017m\u001d5D_\u0012,GCAA9\u0003!!xn\u0015;sS:<GCAA1\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ti\u000b\u0005\u0003\u0002d\u0005=\u0016\u0002BAY\u0003K\u0012aa\u00142kK\u000e$(A\u0003(piJ+hN\\5oONA\u0001\u0005QA\u001c\u0003w\t\t\u0005\u0006\u0002\u0002:B\u0019\u0011\u0011\b\u0011\u0015\t\u0005m\u0014Q\u0018\u0005\n\u0003\u0007#\u0013\u0011!a\u0001\u0003c\"B!!'\u0002B\"I\u00111\u0011\u0014\u0002\u0002\u0003\u0007\u00111P\u0001\u000b\u001d>$(+\u001e8oS:<\u0017\u0001D%oSRL\u0017\r\\5{S:<\u0017A\u00042p_R\u001cHO]1q'R,\u0007\u000fI\u0001\tg\u0016$H/\u001b8hgV\u0011\u0011Q\u001a\t\u00045\u0006=\u0017bAAim\tA2\t\\;ti\u0016\u0014(i\\8ugR\u0014\u0018\r]*fiRLgnZ:\u0002\u0013M,G\u000f^5oON\u0004\u0013!\u00033jg\u000e|g/\u001a:z+\t\tI\u000e\u0005\u0003\u0002\\\u0006}WBAAo\u0015\r\t)\u000eP\u0005\u0005\u0003C\fiN\u0001\tTKJ4\u0018nY3ESN\u001cwN^3ss\u0006Y!n\\5o\t\u0016\u001c\u0017\u000eZ3s+\t\t9\u000fE\u0002[\u0003SL1!a;7\u0005-Qu.\u001b8EK\u000eLG-\u001a:\u0002\u0019)|\u0017N\u001c#fG&$WM\u001d\u0011\u0002)}\u001bX\r\u001c4D_:$\u0018m\u0019;Q_&tG/\u0016:j!\u0019\t\u00190a>\u0002|6\u0011\u0011Q\u001f\u0006\u0003Y\nKA!!?\u0002v\n9\u0001K]8nSN,\u0007\u0003BA\u007f\u0005\u0013i!!a@\u000b\t\t\u0005!1A\u0001\u0006[>$W\r\u001c\u0006\u0004\u001f\n\u0015!b\u0001B\u0004y\u0005!\u0001\u000e\u001e;q\u0013\u0011\u0011Y!a@\u0003\u0007U\u0013\u0018.A\u0005bkR|7\u000f^1siV\u0011\u0011\u0011T\u0001\u000bCV$xn\u001d;beR\u0004\u0013A\u0002:pkR,7\u000f\u0006\u0003\u0003\u0018\t]\u0002\u0003\u0002B\r\u0005cqAAa\u0007\u0003.9!!Q\u0004B\u0015\u001d\u0011\u0011yBa\n\u000f\t\t\u0005\"Q\u0005\b\u0005\u0003\u000f\u0012\u0019#C\u0001>\u0013\r\u00119\u0001P\u0005\u0004\u001f\n\u0015\u0011\u0002\u0002B\u0016\u0005\u0007\taa]3sm\u0016\u0014\u0018\u0002BA)\u0005_QAAa\u000b\u0003\u0004%!!1\u0007B\u001b\u0005\u0015\u0011v.\u001e;f\u0015\u0011\t\tFa\f\t\u000f\ter\u00021\u0001\u0003<\u0005)\"o\\;uKB\u0013xN^5eKJ\u001cV\r\u001e;j]\u001e\u001c\bcA'\u0003>%\u0019!q\b(\u0003?5\u000bg.Y4f[\u0016tGOU8vi\u0016\u0004&o\u001c<jI\u0016\u00148+\u001a;uS:<7/A\u0003ti\u0006\u0014H\u000f\u0006\u0002\u0003FA\u0019\u0011Ia\u0012\n\u0007\t%#I\u0001\u0003V]&$\u0018AF3ogV\u0014XmU3mM\u000e{g\u000e^1diB{\u0017N\u001c;)\u0007E\u0011y\u0005\u0005\u0003\u0003R\t]SB\u0001B*\u0015\r\u0011)\u0006P\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B-\u0005'\u00121\"\u00138uKJt\u0017\r\\!qS\u0006\u00192/\u001a;TK247i\u001c8uC\u000e$\bk\\5oiR!!Q\tB0\u0011\u001d\u0011\tG\u0005a\u0001\u0003w\fqAY1tKV\u0013\u0018\u000eK\u0002\u0013\u0005\u001f\n\u0001c]3mM\u000e{g\u000e^1diB{\u0017N\u001c;\u0016\u0005\t%\u0004CBAz\u0005W\nY0\u0003\u0003\u0003n\u0005U(A\u0002$viV\u0014X\rK\u0002\u0014\u0005\u001f\u0002")
public final class ClusterBootstrap
implements ManagementRouteProvider {
    private ServiceDiscovery discovery;
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final AtomicReference<Internal.BootstrapStep> bootstrapStep;
    private final ClusterBootstrapSettings settings;
    private final JoinDecider joinDecider;
    private final Promise<Uri> _selfContactPointUri;
    private final boolean autostart;
    private volatile boolean bitmap$0;

    public static ClusterBootstrap createExtension(ExtendedActorSystem extendedActorSystem) {
        return ClusterBootstrap$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ClusterBootstrap get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterBootstrap$.MODULE$.get(classicActorSystemProvider);
    }

    public static ClusterBootstrap get(ActorSystem actorSystem) {
        return ClusterBootstrap$.MODULE$.get(actorSystem);
    }

    public static ClusterBootstrap$ lookup() {
        return ClusterBootstrap$.MODULE$.lookup();
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterBootstrap$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return ClusterBootstrap$.MODULE$.apply(actorSystem);
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private final AtomicReference<Internal.BootstrapStep> bootstrapStep() {
        return this.bootstrapStep;
    }

    public ClusterBootstrapSettings settings() {
        return this.settings;
    }

    private ServiceDiscovery discovery$lzycompute() {
        block7: {
            ClusterBootstrap clusterBootstrap = this;
            synchronized (clusterBootstrap) {
                ServiceDiscovery serviceDiscovery;
                block9: {
                    String string;
                    block8: {
                        if (this.bitmap$0) break block7;
                        string = this.settings().contactPointDiscovery().discoveryMethod();
                        switch (string == null ? 0 : string.hashCode()) {
                            case -978464702: {
                                if ("akka.discovery".equals(string)) {
                                    break;
                                }
                                break block8;
                            }
                            default: {
                                break block8;
                            }
                        }
                        ServiceDiscovery discovery = Discovery$.MODULE$.apply((ActorSystem)this.system).discovery();
                        this.log().info("Bootstrap using default `akka.discovery` method: {}", (Object)Logging$.MODULE$.simpleName((Object)discovery));
                        serviceDiscovery = discovery;
                        break block9;
                    }
                    this.log().info("Bootstrap using `akka.discovery` method: {}", (Object)string);
                    serviceDiscovery = Discovery$.MODULE$.apply((ActorSystem)this.system).loadServiceDiscovery(string);
                }
                this.discovery = serviceDiscovery;
                this.bitmap$0 = true;
            }
        }
        return this.discovery;
    }

    public ServiceDiscovery discovery() {
        return !this.bitmap$0 ? this.discovery$lzycompute() : this.discovery;
    }

    private JoinDecider joinDecider() {
        return this.joinDecider;
    }

    private boolean autostart() {
        return this.autostart;
    }

    public Function1<RequestContext, Future<RouteResult>> routes(ManagementRouteProviderSettings routeProviderSettings) {
        this.log().info(new StringBuilder(34).append("Using self contact point address: ").append(routeProviderSettings.selfBaseUri()).toString());
        this.setSelfContactPoint(routeProviderSettings.selfBaseUri());
        return new HttpClusterBootstrapRoutes(this.settings()).routes();
    }

    public void start() {
        if (((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).settings().SeedNodes().nonEmpty()) {
            this.log().warning("Application is configured with specific `akka.cluster.seed-nodes`: {}, bailing out of the bootstrap process! If you want to use the automatic bootstrap mechanism, make sure to NOT set explicit seed nodes in the configuration. This node will attempt to join the configured seed nodes.", (Object)((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).settings().SeedNodes().mkString("[", ", ", "]"));
        } else if (this.bootstrapStep().compareAndSet(ClusterBootstrap$Internal$NotRunning$.MODULE$, ClusterBootstrap$Internal$Initializing$.MODULE$)) {
            this.log().info("Initiating bootstrap procedure using {} method...", (Object)this.settings().contactPointDiscovery().discoveryMethod());
            this.ensureSelfContactPoint();
            Props bootstrapProps = BootstrapCoordinator$.MODULE$.props(this.discovery(), this.joinDecider(), this.settings());
            ActorRef bootstrap = this.system.systemActorOf(bootstrapProps, "bootstrapCoordinator");
            this.selfContactPoint().foreach((Function1 & Serializable)uri -> {
                ClusterBootstrap.$anonfun$start$1(bootstrap, uri);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)this.system.dispatcher());
        } else {
            this.log().warning("Bootstrap already initiated, yet start() method was called again. Ignoring.");
        }
    }

    @InternalApi
    public void ensureSelfContactPoint() {
        this.system.scheduler().scheduleOnce(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            block0: {
                if (this.selfContactPoint().isCompleted()) break block0;
                $this._selfContactPointUri.failure((Throwable)new TimeoutException("Awaiting Bootstrap.selfContactPoint timed out."));
                this.log().error("'Bootstrap.selfContactPoint' was NOT set, but is required for the bootstrap to work if binding bootstrap routes manually and not via akka-management.");
            }
        }, (ExecutionContext)this.system.dispatcher());
    }

    @InternalApi
    public void setSelfContactPoint(Uri baseUri) {
        this._selfContactPointUri.success((Object)baseUri);
    }

    @InternalApi
    public Future<Uri> selfContactPoint() {
        return this._selfContactPointUri.future();
    }

    private final void autostartFailed$1(Throwable ex) {
        this.log().error(ex, "Failed to autostart cluster bootstrap, terminating system");
        this.system.terminate();
    }

    public static final /* synthetic */ void $anonfun$start$1(ActorRef bootstrap$1, Uri uri) {
        BootstrapCoordinator.Protocol.InitiateBootstrapping x$1 = new BootstrapCoordinator.Protocol.InitiateBootstrapping(uri);
        ActorRef x$2 = bootstrap$1.$bang$default$2((Object)x$1);
        bootstrap$1.$bang((Object)x$1, x$2);
    }

    public ClusterBootstrap(ExtendedActorSystem system) {
        BoxedUnit boxedUnit;
        this.system = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, ClusterBootstrap.class, LogSource$.MODULE$.fromAnyClass());
        this.bootstrapStep = new AtomicReference<ClusterBootstrap$Internal$NotRunning$>(ClusterBootstrap$Internal$NotRunning$.MODULE$);
        AkkaVersion$.MODULE$.require("cluster-bootstrap", "2.5.27");
        this.settings = ClusterBootstrapSettings$.MODULE$.apply(system.settings().config(), this.log());
        this.joinDecider = (JoinDecider)system.dynamicAccess().createInstanceFor(this.settings().joinDecider().implClass(), (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(ActorSystem.class, (Object)system), new Tuple2(ClusterBootstrapSettings.class, (Object)this.settings())})), ClassTag$.MODULE$.apply(JoinDecider.class)).get();
        this._selfContactPointUri = Promise$.MODULE$.apply();
        this.autostart = system.settings().config().getStringList("akka.extensions").contains(ClusterBootstrap.class.getName());
        if (this.autostart()) {
            this.log().info("ClusterBootstrap loaded through 'akka.extensions' auto starting management and bootstrap.");
            boxedUnit = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                try {
                    ((AkkaManagement)AkkaManagement$.MODULE$.apply((ActorSystem)$this.system)).start().failed().foreach((Function1 & Serializable)ex -> {
                        this.autostartFailed$1(ex);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)$this.system.dispatcher());
                    ((ClusterBootstrap)ClusterBootstrap$.MODULE$.apply((ActorSystem)$this.system)).start();
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable ex2 = (Throwable)option.get();
                        this.autostartFailed$1(ex2);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
            }, (ExecutionContext)system.dispatcher());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

