/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.server.undertow;

import com.jfinal.server.undertow.UndertowServer;
import com.jfinal.server.undertow.WebSocketConfig;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletInfo;
import javax.servlet.DispatcherType;

public class WebBuilder {
    protected UndertowServer undertowServer;
    protected DeploymentInfo deploymentInfo;
    protected WebSocketConfig webSocketConfig;

    public WebBuilder(UndertowServer undertowServer) {
        this.undertowServer = undertowServer;
        this.deploymentInfo = undertowServer.deploymentInfo;
    }

    protected Class<?> loadClass(String name) {
        try {
            return this.undertowServer.config.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public WebBuilder addFilter(String filterName, String filterClass) {
        Class<?> filter = this.loadClass(filterClass);
        this.deploymentInfo.addFilter(new FilterInfo(filterName, filter));
        return this;
    }

    public WebBuilder addFilterUrlMapping(String filterName, String mapping) {
        return this.addFilterUrlMapping(filterName, mapping, DispatcherType.REQUEST);
    }

    public WebBuilder addFilterUrlMapping(String filterName, String mapping, DispatcherType dispatcherType) {
        this.deploymentInfo.addFilterUrlMapping(filterName, mapping, dispatcherType);
        return this;
    }

    public WebBuilder addFilterInitParam(String filterName, String paraName, String paraValue) {
        if (this.deploymentInfo.getFilters().get(filterName) == null) {
            throw new IllegalStateException("Filter not found : " + filterName + ", using addFilter(...) to add filter first.");
        }
        ((FilterInfo)this.deploymentInfo.getFilters().get(filterName)).addInitParam(paraName, paraValue);
        return this;
    }

    public WebBuilder addServlet(String servletName, String servletClass) {
        Class<?> servlet = this.loadClass(servletClass);
        this.deploymentInfo.addServlet(new ServletInfo(servletName, servlet));
        return this;
    }

    public void checkServlet(String servletName) {
        if (this.deploymentInfo.getServlets().get(servletName) == null) {
            throw new IllegalStateException("Servlet not found : " + servletName + ", using addServlet(...) to add servlet first.");
        }
    }

    public WebBuilder addServletMapping(String servletName, String mapping) {
        this.checkServlet(servletName);
        ((ServletInfo)this.deploymentInfo.getServlets().get(servletName)).addMapping(mapping);
        return this;
    }

    public WebBuilder addServletMappings(String servletName, String ... mappings) {
        this.checkServlet(servletName);
        ServletInfo si = (ServletInfo)this.deploymentInfo.getServlets().get(servletName);
        for (String m : mappings) {
            si.addMapping(m);
        }
        return this;
    }

    public WebBuilder addServletInitParam(String servletName, String paraName, String paraValue) {
        this.checkServlet(servletName);
        ((ServletInfo)this.deploymentInfo.getServlets().get(servletName)).addInitParam(paraName, paraValue);
        return this;
    }

    public WebBuilder setServletAsyncSupported(String servletName, boolean asyncSupported) {
        this.checkServlet(servletName);
        ((ServletInfo)this.deploymentInfo.getServlets().get(servletName)).setAsyncSupported(asyncSupported);
        return this;
    }

    public WebBuilder setServletLoadOnStartup(String servletName, int loadOnStartup) {
        this.checkServlet(servletName);
        ((ServletInfo)this.deploymentInfo.getServlets().get(servletName)).setLoadOnStartup(Integer.valueOf(loadOnStartup));
        return this;
    }

    public WebBuilder addListener(String listenerClass) {
        Class<?> listener = this.loadClass(listenerClass);
        this.deploymentInfo.addListener(new ListenerInfo(listener));
        return this;
    }

    public WebBuilder addWebSocketEndpoint(String webSocketEndpointClass) {
        Class<?> webSocketEndpoint = this.loadClass(webSocketEndpointClass);
        if (this.webSocketConfig == null) {
            this.webSocketConfig = new WebSocketConfig();
        }
        this.webSocketConfig.addWebSocketEndpoint(webSocketEndpoint);
        return this;
    }

    public WebBuilder addWebSocketEndpoint(Class<?> webSocketEndpointClass) {
        return this.addWebSocketEndpoint(webSocketEndpointClass.getName());
    }
}

