/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.util.concurrent.ArrayBlockingQueue;
import org.beetl.core.ContextBuffer;

public class ContextLocalBuffers {
    ArrayBlockingQueue<ContextBuffer> queue = null;
    int bufferMax;

    public ContextLocalBuffers(int num, int bufferMax) {
        this.bufferMax = bufferMax;
        this.queue = new ArrayBlockingQueue(num);
        for (int i = 0; i < num; ++i) {
            ContextBuffer buffer = new ContextBuffer(bufferMax, true);
            this.queue.add(buffer);
        }
    }

    public ContextBuffer getContextLocalBuffer() {
        ContextBuffer buffer = this.queue.poll();
        if (buffer != null) {
            return buffer;
        }
        return new ContextBuffer(this.bufferMax, false);
    }

    public void putContextLocalBuffer(ContextBuffer buffer) {
        if (!buffer.inner) {
            return;
        }
        this.queue.add(buffer);
    }
}

