/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSExpressionMemberMathProduct;
import com.helger.css.decl.ICSSExpressionMathMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSExpressionMemberMathUnitProduct
implements ICSSExpressionMathMember,
ICSSSourceLocationAware {
    private final CSSExpressionMemberMathProduct m_aProduct;

    public CSSExpressionMemberMathUnitProduct(@Nonnull @Nonempty CSSExpressionMemberMathProduct cSSExpressionMemberMathProduct) {
        this.m_aProduct = (CSSExpressionMemberMathProduct)ValueEnforcer.notNull((Object)cSSExpressionMemberMathProduct, (String)"Product");
    }

    @Nonnull
    public CSSExpressionMemberMathProduct getProduct() {
        return this.m_aProduct;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        return "(" + this.m_aProduct.getAsCSSString(iCSSWriterSettings, n) + ")";
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aProduct.setSourceLocation(cSSSourceLocation);
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aProduct.getSourceLocation();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSExpressionMemberMathUnitProduct cSSExpressionMemberMathUnitProduct = (CSSExpressionMemberMathUnitProduct)object;
        return this.m_aProduct.equals(cSSExpressionMemberMathUnitProduct.m_aProduct);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aProduct).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("product", (Object)this.m_aProduct).toString();
    }
}

