/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mime;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.codec.DecodeException;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.EMimeContentType;
import com.helger.commons.mime.EMimeQuoting;
import com.helger.commons.mime.MimeType;
import com.helger.commons.mime.MimeTypeParserException;
import com.helger.commons.string.StringHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MimeTypeParser {
    private static final MimeTypeParser s_aInstance = new MimeTypeParser();
    private static final char[] TSPECIAL = new char[]{'(', ')', '<', '>', '@', ',', ';', ':', '\\', '\"', '/', '[', ']', '?', '='};

    private MimeTypeParser() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static char[] getAllTSpecialChars() {
        return ArrayHelper.getCopy(TSPECIAL);
    }

    public static boolean isTSpecialChar(char c) {
        return ArrayHelper.contains(TSPECIAL, c);
    }

    public static boolean isTokenChar(char c) {
        return c > ' ' && c < '\u007f' && !MimeTypeParser.isTSpecialChar(c);
    }

    public static boolean isToken(@Nullable String string) {
        char[] cArray;
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        for (char c : cArray = string.toCharArray()) {
            if (MimeTypeParser.isTokenChar(c)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void _parseAndAddParameters(@Nonnull MimeType mimeType, @Nonnull @Nonempty String string, @Nonnull EMimeQuoting eMimeQuoting) {
        String[] stringArray;
        if (eMimeQuoting.isQuotedString()) {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            do {
                int n3 = n2;
                while (n2 < n && MimeTypeParser.isTokenChar(cArray[n2])) {
                    ++n2;
                }
                String string2 = string.substring(n3, n2);
                while (n2 < n && cArray[n2] != '=') {
                    ++n2;
                }
                if (n2 == n) {
                    throw new MimeTypeParserException("Missing parameter name/value separator");
                }
                ++n2;
                while (n2 < n && cArray[n2] != '\"' && !MimeTypeParser.isTokenChar(cArray[n2])) {
                    ++n2;
                }
                if (n2 == n) {
                    throw new MimeTypeParserException("Missing parameter value start separator of: " + string);
                }
                StringBuilder stringBuilder = new StringBuilder();
                if (cArray[n2] == '\"') {
                    char c;
                    ++n2;
                    while (n2 < n && (c = cArray[n2]) != '\"') {
                        if (c == '\\') {
                            if (n2 == n - 1) {
                                throw new MimeTypeParserException("Illegal masking found at end of: " + string);
                            }
                            stringBuilder.append(cArray[++n2]);
                        } else {
                            stringBuilder.append(c);
                        }
                        ++n2;
                    }
                    if (n2 == n) {
                        throw new MimeTypeParserException("Missing closing separator in quoted value");
                    }
                    ++n2;
                } else {
                    while (n2 < n && MimeTypeParser.isTokenChar(cArray[n2])) {
                        stringBuilder.append(cArray[n2]);
                        ++n2;
                    }
                }
                String string3 = stringBuilder.toString();
                try {
                    mimeType.addParameter(string2, string3);
                }
                catch (Exception exception) {
                    throw new MimeTypeParserException("Failed to add parameter '" + string2 + "' with value '" + string3 + "'", exception);
                }
                while (n2 < n && cArray[n2] != ';') {
                    ++n2;
                }
                if (n2 == n) return;
                ++n2;
                while (n2 < n && !MimeTypeParser.isTokenChar(cArray[n2])) {
                    ++n2;
                }
            } while (n2 != n);
            throw new MimeTypeParserException("Another parameter was indicated but none was found: " + string);
        }
        for (String string4 : stringArray = StringHelper.getExplodedArray(';', string)) {
            String[] stringArray2 = StringHelper.getExplodedArray('=', string4, 2);
            if (stringArray2.length != 2) {
                throw new MimeTypeParserException("MimeType Parameter without name/value separator found: '" + string4 + "'");
            }
            String string5 = stringArray2[0].trim();
            String string6 = stringArray2[1].trim();
            try {
                string6 = eMimeQuoting.getUnquotedString(string6);
            }
            catch (DecodeException decodeException) {
                throw new MimeTypeParserException("Failed to unquote the string '" + string6 + "'", decodeException);
            }
            try {
                mimeType.addParameter(string5, string6);
            }
            catch (Exception exception) {
                throw new MimeTypeParserException("Failed to add parameter '" + string5 + "' with value '" + string6 + "'", exception);
            }
        }
    }

    @Nullable
    public static MimeType parseMimeType(@Nullable String string) {
        return MimeTypeParser.parseMimeType(string, CMimeType.DEFAULT_QUOTING);
    }

    @Nullable
    public static MimeType parseMimeType(@Nullable String string, @Nonnull EMimeQuoting eMimeQuoting) {
        String string2;
        String string3;
        ValueEnforcer.notNull(eMimeQuoting, "QuotingAlgorithm");
        String string4 = StringHelper.trim(string);
        if (StringHelper.hasNoText(string4)) {
            return null;
        }
        if (string4.equals("*")) {
            return new MimeType(EMimeContentType._STAR, "*");
        }
        int n = string4.indexOf(47);
        if (n < 0) {
            throw new MimeTypeParserException("MimeType '" + string4 + "' is missing the main '/' separator char");
        }
        String string5 = string4.substring(0, n).trim();
        EMimeContentType eMimeContentType = EMimeContentType.getFromIDOrNull(string5);
        if (eMimeContentType == null) {
            throw new MimeTypeParserException("MimeType '" + string4 + "' uses an unknown content type '" + string5 + "'");
        }
        String string6 = string4.substring(n + 1);
        int n2 = string6.indexOf(59);
        if (n2 >= 0) {
            string3 = string6.substring(0, n2).trim();
            string2 = string6.substring(n2 + 1).trim();
        } else {
            string3 = string6.trim();
            string2 = null;
        }
        if (StringHelper.hasNoText(string3)) {
            throw new MimeTypeParserException("MimeType '" + string4 + "' uses an empty content sub type '" + string4 + "'");
        }
        MimeType mimeType = new MimeType(eMimeContentType, string3);
        if (StringHelper.hasText(string2)) {
            MimeTypeParser._parseAndAddParameters(mimeType, string2, eMimeQuoting);
        }
        return mimeType;
    }

    @Nullable
    public static MimeType safeParseMimeType(@Nullable String string) {
        try {
            return MimeTypeParser.parseMimeType(string, CMimeType.DEFAULT_QUOTING);
        }
        catch (MimeTypeParserException mimeTypeParserException) {
            return null;
        }
    }

    @Nullable
    public static MimeType safeParseMimeType(@Nullable String string, @Nonnull EMimeQuoting eMimeQuoting) {
        try {
            return MimeTypeParser.parseMimeType(string, eMimeQuoting);
        }
        catch (MimeTypeParserException mimeTypeParserException) {
            return null;
        }
    }
}

