/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.statistics;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.collection.ext.ICommonsSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.statistics.IStatisticsHandlerKeyedNumeric;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractStatisticsHandlerKeyedNumeric
implements IStatisticsHandlerKeyedNumeric {
    private final transient SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final AtomicInteger m_aInvocationCount = new AtomicInteger(0);
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, Value> m_aMap = new CommonsHashMap<String, Value>();

    @Override
    @Nonnegative
    public final int getInvocationCount() {
        return this.m_aInvocationCount.get();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllKeys() {
        return this.m_aRWLock.readLocked(() -> this.m_aMap.copyOfKeySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addValue(@Nullable String string, long l) {
        this.m_aInvocationCount.incrementAndGet();
        this.m_aRWLock.writeLock().lock();
        try {
            Value value = (Value)this.m_aMap.get(string);
            if (value == null) {
                this.m_aMap.put(string, new Value(l));
            } else {
                value.add(l);
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Override
    @CheckForSigned
    public final int getInvocationCount(@Nullable String string) {
        return this.m_aRWLock.readLocked(() -> {
            Value value = (Value)this.m_aMap.get(string);
            return value == null ? -1 : value.getInvocationCount();
        });
    }

    @Override
    @Nullable
    public final BigInteger getSum(@Nullable String string) {
        return this.m_aRWLock.readLocked(() -> {
            Value value = (Value)this.m_aMap.get(string);
            return value == null ? null : value.getSum();
        });
    }

    @Override
    @CheckForSigned
    public final long getMin(@Nullable String string) {
        return this.m_aRWLock.readLocked(() -> {
            Value value = (Value)this.m_aMap.get(string);
            return value == null ? -1L : value.getMin();
        });
    }

    @Override
    @CheckForSigned
    public final long getAverage(@Nullable String string) {
        return this.m_aRWLock.readLocked(() -> {
            Value value = (Value)this.m_aMap.get(string);
            return value == null ? -1L : value.getAverage();
        });
    }

    @Override
    @CheckForSigned
    public long getMax(@Nullable String string) {
        return this.m_aRWLock.readLocked(() -> {
            Value value = (Value)this.m_aMap.get(string);
            return value == null ? -1L : value.getMax();
        });
    }

    private static final class Value
    implements Serializable {
        private int m_nInvocationCount = 1;
        private long m_nMin;
        private long m_nMax;
        private BigInteger m_aSum;

        public Value(long l) {
            this.m_nMin = l;
            this.m_nMax = l;
            this.m_aSum = BigInteger.valueOf(l);
        }

        public void add(long l) {
            ++this.m_nInvocationCount;
            if (l < this.m_nMin) {
                this.m_nMin = l;
            }
            if (l > this.m_nMax) {
                this.m_nMax = l;
            }
            this.m_aSum = this.m_aSum.add(BigInteger.valueOf(l));
        }

        @Nonnegative
        public int getInvocationCount() {
            return this.m_nInvocationCount;
        }

        @CheckForSigned
        public long getMin() {
            return this.m_nMin;
        }

        @CheckForSigned
        public long getMax() {
            return this.m_nMax;
        }

        @Nonnull
        public BigInteger getSum() {
            return this.m_aSum;
        }

        @CheckForSigned
        public long getAverage() {
            return this.m_aSum.divide(BigInteger.valueOf(this.m_nInvocationCount)).longValue();
        }

        public String toString() {
            return new ToStringGenerator(null).append("invocations", this.m_nInvocationCount).append("min", this.m_nMin).append("max", this.m_nMax).append("sum", this.m_aSum).getToString();
        }
    }
}

