/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.resource.wrapped;

import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resource.wrapped.AbstractWrappedReadableResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GZIPReadableResource
extends AbstractWrappedReadableResource {
    public GZIPReadableResource(@Nonnull IReadableResource iReadableResource) {
        super(iReadableResource);
    }

    @Override
    @Nullable
    public InputStream getInputStream() {
        InputStream inputStream = this.getBaseResource().getInputStream();
        if (inputStream == null) {
            return null;
        }
        try {
            return new GZIPInputStream(inputStream);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to open GZIP InputStream", iOException);
        }
    }

    @Override
    @Nonnull
    public GZIPReadableResource getReadableCloneForPath(@Nonnull String string) {
        return new GZIPReadableResource(this.getBaseResource().getReadableCloneForPath(string));
    }
}

