/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.concurrent;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.ToStringGenerator;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasicThreadFactory
implements ThreadFactory {
    private final AtomicLong m_aThreadCounter = new AtomicLong();
    private final ThreadFactory m_aWrappedFactory;
    private final Thread.UncaughtExceptionHandler m_aUncaughtExceptionHandler;
    private final String m_sNamingPattern;
    private final Integer m_aPriority;
    private final ETriState m_eDaemon;

    protected BasicThreadFactory(@Nonnull Builder builder) {
        this.m_aWrappedFactory = builder.m_aWrappedFactory == null ? Executors.defaultThreadFactory() : builder.m_aWrappedFactory;
        this.m_sNamingPattern = builder.m_sNamingPattern;
        this.m_aPriority = builder.m_nPriority;
        this.m_eDaemon = builder.m_eDaemon;
        this.m_aUncaughtExceptionHandler = builder.m_aUncaughtExceptionHandler;
    }

    @Nonnull
    public final ThreadFactory getWrappedFactory() {
        return this.m_aWrappedFactory;
    }

    @Nonnull
    public final String getNamingPattern() {
        return this.m_sNamingPattern;
    }

    @Nonnull
    public final ETriState getDaemon() {
        return this.m_eDaemon;
    }

    @Nullable
    public final Integer getPriority() {
        return this.m_aPriority;
    }

    public final Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.m_aUncaughtExceptionHandler;
    }

    @Nonnull
    public long getThreadCount() {
        return this.m_aThreadCounter.get();
    }

    @Override
    @Nonnull
    public Thread newThread(@Nonnull Runnable runnable) {
        ValueEnforcer.notNull(runnable, "Runnable");
        Thread thread = this.getWrappedFactory().newThread(runnable);
        this.initializeThread(thread);
        return thread;
    }

    @OverrideOnDemand
    protected void initializeThread(@Nonnull Thread thread) {
        if (this.m_sNamingPattern != null) {
            Long l = this.m_aThreadCounter.incrementAndGet();
            thread.setName(String.format(Locale.US, this.m_sNamingPattern, l));
        }
        if (this.m_aUncaughtExceptionHandler != null) {
            thread.setUncaughtExceptionHandler(this.m_aUncaughtExceptionHandler);
        }
        if (this.m_aPriority != null) {
            thread.setPriority(this.m_aPriority);
        }
        if (this.m_eDaemon.isDefined()) {
            thread.setDaemon(this.m_eDaemon.getAsBooleanValue());
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("ThreadCounter", this.m_aThreadCounter).append("WrappedFactory", this.m_aWrappedFactory).append("UncaughtExceptionHandler", this.m_aUncaughtExceptionHandler).append("NamingPattern", this.m_sNamingPattern).append("Priority", this.m_aPriority).append("Daemon", this.m_eDaemon).getToString();
    }

    public static class Builder {
        private ThreadFactory m_aWrappedFactory;
        private Thread.UncaughtExceptionHandler m_aUncaughtExceptionHandler;
        private String m_sNamingPattern;
        private Integer m_nPriority;
        private ETriState m_eDaemon = ETriState.UNDEFINED;

        @Nonnull
        public Builder setWrappedFactory(ThreadFactory threadFactory) {
            ValueEnforcer.notNull(threadFactory, "Factory");
            this.m_aWrappedFactory = threadFactory;
            return this;
        }

        @Nonnull
        public Builder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            ValueEnforcer.notNull(uncaughtExceptionHandler, "ExceptionHandler");
            this.m_aUncaughtExceptionHandler = uncaughtExceptionHandler;
            return this;
        }

        @Nonnull
        public Builder setNamingPattern(String string) {
            ValueEnforcer.notNull(string, "NamingPattern");
            this.m_sNamingPattern = string;
            return this;
        }

        @Nonnull
        public Builder setPriority(int n) {
            this.m_nPriority = n;
            return this;
        }

        @Nonnull
        public Builder setDaemon(boolean bl) {
            this.m_eDaemon = ETriState.valueOf(bl);
            return this;
        }

        public void reset() {
            this.m_aWrappedFactory = null;
            this.m_aUncaughtExceptionHandler = null;
            this.m_sNamingPattern = null;
            this.m_nPriority = null;
            this.m_eDaemon = null;
        }

        @Nonnull
        public BasicThreadFactory build() {
            return this.build(true);
        }

        @Nonnull
        public BasicThreadFactory build(boolean bl) {
            BasicThreadFactory basicThreadFactory = new BasicThreadFactory(this);
            if (bl) {
                this.reset();
            }
            return basicThreadFactory;
        }
    }
}

