/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.callback.exception;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.callback.exception.IExceptionCallback;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CollectingExceptionListCallback<EXTYPE extends Throwable>
implements IExceptionCallback<EXTYPE> {
    private final ICommonsList<EXTYPE> m_aExceptions = new CommonsArrayList<EXTYPE>();

    @Override
    public void onException(@Nullable EXTYPE EXTYPE) {
        this.m_aExceptions.addIfNotNull(EXTYPE);
    }

    public boolean hasException() {
        return this.m_aExceptions.isNotEmpty();
    }

    @Nonnegative
    public int getExceptionCount() {
        return this.m_aExceptions.size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<EXTYPE> getAllExceptions() {
        return (ICommonsList)this.m_aExceptions.getClone();
    }

    public String toString() {
        return new ToStringGenerator(this).append("exceptions", this.m_aExceptions).getToString();
    }
}

