/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mock;

import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.annotation.IsSPIInterface;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.cache.AnnotationUsageCache;
import com.helger.commons.collection.multimap.MultiTreeMapTreeSetBased;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.iterate.FileSystemIterator;
import com.helger.commons.io.stream.NonBlockingBufferedReader;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.lang.ReflectionSecurityManager;
import com.helger.commons.string.StringHelper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SPITestHelper {
    public static final String TEST_SERVICES = "src/test/resources/META-INF/services";
    public static final String MAIN_SERVICES = "src/main/resources/META-INF/services";
    private static final Logger s_aLogger = LoggerFactory.getLogger(SPITestHelper.class);
    private static final AnnotationUsageCache s_aCacheInterface = new AnnotationUsageCache(IsSPIInterface.class);
    private static final AnnotationUsageCache s_aCacheImplementation = new AnnotationUsageCache(IsSPIImplementation.class);

    private SPITestHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static MultiTreeMapTreeSetBased<String, String> testIfAllSPIImplementationsAreValid(@Nonnull String string, @Nonnull EMode eMode) throws IOException {
        boolean bl = eMode.isResolve();
        ClassLoader classLoader = ReflectionSecurityManager.INSTANCE.getCallerClass(1).getClassLoader();
        MultiTreeMapTreeSetBased<String, String> multiTreeMapTreeSetBased = new MultiTreeMapTreeSetBased<String, String>();
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            for (File file2 : new FileSystemIterator(string)) {
                Object object;
                Object object2;
                String string2;
                block23: {
                    if (!file2.isFile()) continue;
                    if (bl) {
                        s_aLogger.info("Checking SPI file " + file2.getAbsolutePath());
                    }
                    string2 = file2.getName();
                    if (bl) {
                        try {
                            object2 = classLoader.loadClass(string2);
                            if (string2.startsWith("com.helger.") && !s_aCacheInterface.hasAnnotation((Class<?>)object2)) {
                                s_aLogger.warn(object2 + " should have the @IsSPIInterface annotation");
                            }
                        }
                        catch (Throwable throwable) {
                            object = "No interface representing " + string2 + " exists: " + ClassHelper.getClassLocalName(throwable) + " - " + throwable.getMessage();
                            s_aLogger.warn((String)object);
                            if (!eMode.isStrict()) break block23;
                            throw new IllegalStateException((String)object);
                        }
                    }
                }
                object2 = new NonBlockingBufferedReader(StreamHelper.createReader(FileHelper.getInputStream(file2), StandardCharsets.UTF_8));
                object = null;
                try {
                    String string3;
                    int n = 0;
                    while ((string3 = ((NonBlockingBufferedReader)object2).readLine()) != null) {
                        String string4 = StringHelper.trim(string3);
                        if (!StringHelper.hasText(string4)) continue;
                        if (bl) {
                            try {
                                Class<?> clazz = classLoader.loadClass(string4);
                                if (!s_aCacheImplementation.hasAnnotation(clazz)) {
                                    s_aLogger.warn(clazz + " should have the @IsSPIImplementation annotation");
                                }
                                ++n;
                                multiTreeMapTreeSetBased.putSingle(string2, string4);
                                continue;
                            }
                            catch (Throwable throwable) {
                                s_aLogger.warn("  Error checking content: " + throwable.getMessage());
                                if (!eMode.isStrict()) continue;
                                throw new IllegalStateException("Error checking SPI file " + file2.getAbsolutePath(), throwable);
                            }
                        }
                        ++n;
                        multiTreeMapTreeSetBased.putSingle(string2, string4);
                    }
                    if (!bl) continue;
                    if (n == 0) {
                        s_aLogger.warn("  Contains no single valid implementation!");
                        continue;
                    }
                    s_aLogger.info("  All implementations (" + n + ") are valid!");
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 == null) continue;
                    if (object != null) {
                        try {
                            ((NonBlockingBufferedReader)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        continue;
                    }
                    ((NonBlockingBufferedReader)object2).close();
                }
            }
        }
        return multiTreeMapTreeSetBased;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static MultiTreeMapTreeSetBased<String, String> testIfAllMainSPIImplementationsAreValid(boolean bl) throws IOException {
        return SPITestHelper.testIfAllSPIImplementationsAreValid(MAIN_SERVICES, bl ? EMode.IGNORE_ERRORS : EMode.STRICT);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static MultiTreeMapTreeSetBased<String, String> testIfAllTestSPIImplementationsAreValid(boolean bl) throws IOException {
        return SPITestHelper.testIfAllSPIImplementationsAreValid(TEST_SERVICES, bl ? EMode.IGNORE_ERRORS : EMode.STRICT);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static MultiTreeMapTreeSetBased<String, String> testIfAllSPIImplementationsAreValid(boolean bl) throws IOException {
        MultiTreeMapTreeSetBased<String, String> multiTreeMapTreeSetBased = SPITestHelper.testIfAllMainSPIImplementationsAreValid(bl);
        multiTreeMapTreeSetBased.putAll(SPITestHelper.testIfAllTestSPIImplementationsAreValid(bl));
        return multiTreeMapTreeSetBased;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static MultiTreeMapTreeSetBased<String, String> testIfAllSPIImplementationsAreValid() throws IOException {
        return SPITestHelper.testIfAllSPIImplementationsAreValid(false);
    }

    public static enum EMode {
        STRICT,
        IGNORE_ERRORS,
        NO_RESOLVE;


        public boolean isStrict() {
            return this == STRICT;
        }

        public boolean isResolve() {
            return this != NO_RESOLVE;
        }
    }
}

