/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.resource.wrapped;

import com.helger.commons.io.EAppend;
import com.helger.commons.io.resource.IWritableResource;
import com.helger.commons.io.resource.wrapped.AbstractWrappedWritableResource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GZIPWritableResource
extends AbstractWrappedWritableResource {
    public GZIPWritableResource(@Nonnull IWritableResource iWritableResource) {
        super(iWritableResource);
    }

    @Override
    @Nullable
    public OutputStream getOutputStream(@Nonnull EAppend eAppend) {
        OutputStream outputStream = this.getBaseResource().getOutputStream(eAppend);
        if (outputStream == null) {
            return null;
        }
        try {
            return new GZIPOutputStream(outputStream);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to open GZIP OutputStream", iOException);
        }
    }

    @Override
    @Nonnull
    public GZIPWritableResource getWritableCloneForPath(@Nonnull String string) {
        return new GZIPWritableResource(this.getBaseResource().getWritableCloneForPath(string));
    }
}

