/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.error;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.error.IError;
import com.helger.commons.error.IErrorTextProvider;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.lang.StackTraceHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ErrorTextProvider
implements IErrorTextProvider,
Serializable,
ICloneable<ErrorTextProvider> {
    public static final char PLACEHOLDER = '$';
    public static final String PLACEHOLDER_STR = Character.toString('$');
    public static final IErrorTextProvider DEFAULT = new ErrorTextProvider().addItem(EField.ERROR_LEVEL, "[$]").addItem(EField.ERROR_ID, "[$]").addItem(EField.ERROR_FIELD_NAME, "in $").addItem(EField.ERROR_LOCATION, "@ $").addItem(EField.ERROR_TEXT, "$").addItem(EField.ERROR_LINKED_EXCEPTION_CLASS, "($:").addItem(EField.ERROR_LINKED_EXCEPTION_MESSAGE, "$)").setFieldSeparator(" ");
    private final ICommonsList<IFormattableItem> m_aItems;
    private String m_sFieldSep = " ";

    public ErrorTextProvider() {
        this.m_aItems = new CommonsArrayList<IFormattableItem>();
    }

    public ErrorTextProvider(@Nonnull ErrorTextProvider errorTextProvider) {
        this.m_aItems = (ICommonsList)errorTextProvider.m_aItems.getClone();
        this.m_sFieldSep = errorTextProvider.m_sFieldSep;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IFormattableItem> getAllItems() {
        return (ICommonsList)this.m_aItems.getClone();
    }

    @Nonnull
    public ErrorTextProvider addItem(@Nonnull EField eField, @Nonnull @Nonempty String string) {
        return this.addItem(new FormattableItem(eField, string));
    }

    @Nonnull
    public ErrorTextProvider addItem(@Nonnull IFormattableItem iFormattableItem) {
        ValueEnforcer.notNull(iFormattableItem, "Item");
        this.m_aItems.add(iFormattableItem);
        return this;
    }

    @Nonnull
    public String getFieldSeparator() {
        return this.m_sFieldSep;
    }

    @Nonnull
    public ErrorTextProvider setFieldSeparator(@Nonnull String string) {
        this.m_sFieldSep = ValueEnforcer.notNull(string, "FieldSep");
        return this;
    }

    @Override
    @Nonnull
    public String getErrorText(@Nonnull IError iError, @Nonnull Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        block14: for (IFormattableItem iFormattableItem : this.m_aItems) {
            switch (iFormattableItem.getField()) {
                case CONSTANT: {
                    stringBuilder.append(iFormattableItem.getUnformattedText());
                    break;
                }
                case ERROR_LEVEL: {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText((String)iError.getErrorLevel().getID()));
                    break;
                }
                case ERROR_ID: {
                    if (!iError.hasErrorID()) continue block14;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(iError.getErrorID()));
                    break;
                }
                case ERROR_FIELD_NAME: {
                    if (!iError.hasErrorFieldName()) continue block14;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(iError.getErrorFieldName()));
                    break;
                }
                case ERROR_LOCATION: {
                    Object object2 = iError.getErrorLocation();
                    if (!object2.isAnyInformationPresent()) continue block14;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(object2.getAsString()));
                    break;
                }
                case ERROR_TEXT: {
                    Object object2 = iError.getErrorText(locale);
                    if (!StringHelper.hasText((String)object2)) continue block14;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText((String)object2));
                    break;
                }
                case ERROR_LINKED_EXCEPTION_CLASS: {
                    Object object2 = iError.getLinkedException();
                    if (object2 == null) continue block14;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(object2.getClass().getName()));
                    break;
                }
                case ERROR_LINKED_EXCEPTION_MESSAGE: {
                    Object object;
                    Object object2 = iError.getLinkedException();
                    if (object2 == null || !StringHelper.hasText((String)(object = ((Throwable)object2).getMessage()))) continue block14;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText((String)object));
                    break;
                }
                case ERROR_LINKED_EXCEPTION_STACK_TRACE: {
                    Object object2 = iError.getLinkedException();
                    if (object2 == null) continue block14;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(StackTraceHelper.getStackAsString((Throwable)object2)));
                    break;
                }
                case ERROR_LINKED_EXCEPTION_CAUSE_CLASS: {
                    Object object2 = iError.getLinkedException();
                    Object object = object2 != null ? ((Throwable)object2).getCause() : null;
                    if (object == null) continue block14;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(object.getClass().getName()));
                    break;
                }
                case ERROR_LINKED_EXCEPTION_CAUSE_MESSAGE: {
                    String string;
                    Object object2 = iError.getLinkedException();
                    Object object = object2 != null ? ((Throwable)object2).getCause() : null;
                    if (object == null || !StringHelper.hasText(string = ((Throwable)object).getMessage())) continue block14;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(string));
                    break;
                }
                case ERROR_LINKED_EXCEPTION_CAUSE_STACK_TRACE: {
                    Object object2 = iError.getLinkedException();
                    Object object = object2 != null ? ((Throwable)object2).getCause() : null;
                    if (object == null) continue block14;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(this.m_sFieldSep);
                    }
                    stringBuilder.append(iFormattableItem.getFormattedText(StackTraceHelper.getStackAsString((Throwable)object)));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported error field " + iFormattableItem.getField());
                }
            }
        }
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ErrorTextProvider getClone() {
        return new ErrorTextProvider(this);
    }

    public String toString() {
        return new ToStringGenerator(this).append("Items", this.m_aItems).append("FieldSeparator", this.m_sFieldSep).getToString();
    }

    public static final class FormattableItem
    implements IFormattableItem {
        private final EField m_eField;
        private final String m_sText;

        public FormattableItem(@Nonnull EField eField, @Nonnull @Nonempty String string) {
            this.m_eField = ValueEnforcer.notNull(eField, "Field");
            this.m_sText = ValueEnforcer.notEmpty(string, "Text");
            if (eField.isPlaceholderRequired()) {
                ValueEnforcer.isTrue(this.m_sText.contains(PLACEHOLDER_STR), () -> "Text '" + string + "' is missing placeholder '" + '$' + "'");
            }
        }

        @Override
        @Nonnull
        public EField getField() {
            return this.m_eField;
        }

        @Override
        @Nonnull
        @Nonempty
        public String getUnformattedText() {
            return this.m_sText;
        }

        @Override
        @Nonnull
        public String getFormattedText(@Nonnull String string) {
            return StringHelper.replaceAll(this.m_sText, PLACEHOLDER_STR, string);
        }

        public String toString() {
            return new ToStringGenerator(this).append("Field", this.m_eField).append("Text", this.m_sText).getToString();
        }
    }

    public static interface IFormattableItem
    extends Serializable {
        @Nonnull
        public EField getField();

        @Nonnull
        public String getUnformattedText();

        @Nonnull
        public String getFormattedText(@Nonnull String var1);
    }

    public static enum EField implements IHasID<String>
    {
        CONSTANT("const"),
        ERROR_LEVEL("level"),
        ERROR_ID("id"),
        ERROR_FIELD_NAME("fieldname"),
        ERROR_LOCATION("location"),
        ERROR_TEXT("text"),
        ERROR_LINKED_EXCEPTION_CLASS("%lec"),
        ERROR_LINKED_EXCEPTION_MESSAGE("%lem"),
        ERROR_LINKED_EXCEPTION_STACK_TRACE("%lest"),
        ERROR_LINKED_EXCEPTION_CAUSE_CLASS("%lecc"),
        ERROR_LINKED_EXCEPTION_CAUSE_MESSAGE("%lecm"),
        ERROR_LINKED_EXCEPTION_CAUSE_STACK_TRACE("%lecst");

        private final String m_sID;

        private EField(String string2) {
            this.m_sID = string2;
        }

        @Override
        @Nonnull
        @Nonempty
        public String getID() {
            return this.m_sID;
        }

        public boolean isPlaceholderRequired() {
            return this != CONSTANT;
        }

        @Nullable
        public static EField getFromIDOrNull(@Nullable String string) {
            return EnumHelper.getFromIDOrNull(EField.class, string);
        }
    }
}

