/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.multimap;

import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.function.ITriConsumer;
import com.helger.commons.state.EChange;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IMultiMapMapBased<KEYTYPE1, KEYTYPE2, VALUETYPE, MAPTYPE extends ICommonsMap<KEYTYPE2, VALUETYPE>>
extends ICommonsMap<KEYTYPE1, MAPTYPE> {
    @Nonnull
    @ReturnsMutableObject(value="design")
    public MAPTYPE getOrCreate(@Nonnull KEYTYPE1 var1);

    @Nonnull
    default public EChange putSingle(@Nonnull KEYTYPE1 KEYTYPE1, @Nonnull KEYTYPE2 KEYTYPE2, @Nullable VALUETYPE VALUETYPE) {
        return EChange.valueOf(this.getOrCreate(KEYTYPE1).put(KEYTYPE2, VALUETYPE) != null);
    }

    @Nonnull
    default public EChange putAllIn(@Nonnull Map<? extends KEYTYPE1, ? extends Map<KEYTYPE2, VALUETYPE>> map) {
        EChange eChange = EChange.UNCHANGED;
        for (Map.Entry<KEYTYPE1, Map<KEYTYPE2, VALUETYPE>> entry : map.entrySet()) {
            for (Map.Entry<KEYTYPE2, VALUETYPE> entry2 : entry.getValue().entrySet()) {
                eChange = eChange.or(this.putSingle(entry.getKey(), entry2.getKey(), entry2.getValue()));
            }
        }
        return eChange;
    }

    @Nonnull
    default public EChange removeSingle(@Nonnull KEYTYPE1 KEYTYPE1, @Nonnull KEYTYPE2 KEYTYPE2) {
        ICommonsMap iCommonsMap = (ICommonsMap)this.get(KEYTYPE1);
        return iCommonsMap == null ? EChange.UNCHANGED : iCommonsMap.removeObject(KEYTYPE2);
    }

    @Nullable
    default public VALUETYPE getSingle(@Nonnull KEYTYPE1 KEYTYPE1, @Nonnull KEYTYPE2 KEYTYPE2) {
        ICommonsMap iCommonsMap = (ICommonsMap)this.get(KEYTYPE1);
        return iCommonsMap == null ? null : (VALUETYPE)iCommonsMap.get(KEYTYPE2);
    }

    default public boolean containsSingle(@Nonnull KEYTYPE1 KEYTYPE1, @Nonnull KEYTYPE2 KEYTYPE2) {
        ICommonsMap iCommonsMap = (ICommonsMap)this.get(KEYTYPE1);
        return iCommonsMap != null && iCommonsMap.containsKey(KEYTYPE2);
    }

    @Nonnegative
    default public long getTotalValueCount() {
        long l = 0L;
        for (Map map : this.values()) {
            l += (long)map.size();
        }
        return l;
    }

    default public void forEachSingle(@Nonnull ITriConsumer<KEYTYPE1, KEYTYPE2, VALUETYPE> iTriConsumer) {
        for (Map.Entry entry : this.entrySet()) {
            for (Map.Entry entry2 : ((ICommonsMap)entry.getValue()).entrySet()) {
                iTriConsumer.accept(entry.getKey(), entry2.getKey(), entry2.getValue());
            }
        }
    }
}

