/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MapperIterator<SRCTYPE, ELEMENTTYPE>
implements IIterableIterator<ELEMENTTYPE> {
    private final Iterator<? extends SRCTYPE> m_aBaseIter;
    private final Function<? super SRCTYPE, ? extends ELEMENTTYPE> m_aConverter;

    public MapperIterator(@Nonnull IIterableIterator<? extends SRCTYPE> iIterableIterator, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        this(iIterableIterator.iterator(), function);
    }

    public MapperIterator(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        this(iterable.iterator(), function);
    }

    public MapperIterator(@Nonnull Iterator<? extends SRCTYPE> iterator, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        this.m_aBaseIter = ValueEnforcer.notNull(iterator, "BaseIterator");
        this.m_aConverter = ValueEnforcer.notNull(function, "Filter");
    }

    @Nonnull
    public Function<? super SRCTYPE, ? extends ELEMENTTYPE> getConverter() {
        return this.m_aConverter;
    }

    @Override
    public boolean hasNext() {
        return this.m_aBaseIter.hasNext();
    }

    @Override
    @Nullable
    public ELEMENTTYPE next() {
        SRCTYPE SRCTYPE = this.m_aBaseIter.next();
        return this.m_aConverter.apply(SRCTYPE);
    }

    @Override
    public void remove() {
        this.m_aBaseIter.remove();
    }

    public String toString() {
        return new ToStringGenerator(this).append("baseIter", this.m_aBaseIter).append("converter", this.m_aConverter).getToString();
    }
}

