/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.ext;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.ext.ICommonsSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommonsHashSet<ELEMENTTYPE>
extends HashSet<ELEMENTTYPE>
implements ICommonsSet<ELEMENTTYPE> {
    public CommonsHashSet() {
    }

    public CommonsHashSet(int n) {
        super(n);
    }

    public CommonsHashSet(int n, @Nonnegative float f) {
        super(n, f);
    }

    public CommonsHashSet(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        super(CollectionHelper.getSize(collection));
        if (collection != null) {
            this.addAll(collection);
        }
    }

    public CommonsHashSet(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        this.addAll(iterable);
    }

    public <SRCTYPE> CommonsHashSet(@Nullable Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        super(CollectionHelper.getSize(collection));
        this.addAllMapped(collection, function);
    }

    public <SRCTYPE> CommonsHashSet(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        this.addAllMapped(iterable, function);
    }

    public CommonsHashSet(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        super(1);
        this.add(ELEMENTTYPE);
    }

    @SafeVarargs
    public CommonsHashSet(ELEMENTTYPE ... ELEMENTTYPEArray) {
        super(ArrayHelper.getSize(ELEMENTTYPEArray));
        this.addAll(ELEMENTTYPEArray);
    }

    public <SRCTYPE> CommonsHashSet(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        super(ArrayHelper.getSize(SRCTYPEArray));
        this.addAllMapped(SRCTYPEArray, function);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public <T> CommonsHashSet<T> createInstance() {
        return new CommonsHashSet<ELEMENTTYPE>();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public CommonsHashSet<ELEMENTTYPE> getClone() {
        return new CommonsHashSet<CommonsHashSet>(this);
    }
}

