/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.QueueHelper;
import com.helger.commons.collection.StackHelper;
import com.helger.commons.collection.VectorHelper;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.CommonsHashSet;
import com.helger.commons.collection.ext.CommonsLinkedHashSet;
import com.helger.commons.collection.ext.CommonsTreeSet;
import com.helger.commons.collection.ext.CommonsVector;
import com.helger.commons.collection.impl.NonBlockingStack;
import java.util.PriorityQueue;
import javax.annotation.Nonnull;

public final class PrimitiveCollectionHelper {
    private PrimitiveCollectionHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsArrayList<Boolean> newPrimitiveList(boolean ... blArray) {
        CommonsArrayList<Boolean> commonsArrayList = CollectionHelper.newList();
        if (blArray != null) {
            for (boolean bl : blArray) {
                commonsArrayList.add(bl);
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsArrayList<Byte> newPrimitiveList(byte ... byArray) {
        CommonsArrayList<Byte> commonsArrayList = CollectionHelper.newList();
        if (byArray != null) {
            for (byte by : byArray) {
                commonsArrayList.add(by);
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsArrayList<Character> newPrimitiveList(char ... cArray) {
        CommonsArrayList<Character> commonsArrayList = CollectionHelper.newList();
        if (cArray != null) {
            for (char c : cArray) {
                commonsArrayList.add(Character.valueOf(c));
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsArrayList<Double> newPrimitiveList(double ... dArray) {
        CommonsArrayList<Double> commonsArrayList = CollectionHelper.newList();
        if (dArray != null) {
            for (double d : dArray) {
                commonsArrayList.add(d);
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsArrayList<Float> newPrimitiveList(float ... fArray) {
        CommonsArrayList<Float> commonsArrayList = CollectionHelper.newList();
        if (fArray != null) {
            for (float f : fArray) {
                commonsArrayList.add(Float.valueOf(f));
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsArrayList<Integer> newPrimitiveList(int ... nArray) {
        CommonsArrayList<Integer> commonsArrayList = CollectionHelper.newList();
        if (nArray != null) {
            for (int n : nArray) {
                commonsArrayList.add(n);
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsArrayList<Long> newPrimitiveList(long ... lArray) {
        CommonsArrayList<Long> commonsArrayList = CollectionHelper.newList();
        if (lArray != null) {
            for (long l : lArray) {
                commonsArrayList.add(l);
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsArrayList<Short> newPrimitiveList(short ... sArray) {
        CommonsArrayList<Short> commonsArrayList = CollectionHelper.newList();
        if (sArray != null) {
            for (short s : sArray) {
                commonsArrayList.add(s);
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsVector<Boolean> newPrimitiveVector(boolean ... blArray) {
        CommonsVector<Boolean> commonsVector = VectorHelper.newVector();
        if (blArray != null) {
            for (boolean bl : blArray) {
                commonsVector.add(bl);
            }
        }
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsVector<Byte> newPrimitiveVector(byte ... byArray) {
        CommonsVector<Byte> commonsVector = VectorHelper.newVector();
        if (byArray != null) {
            for (byte by : byArray) {
                commonsVector.add(by);
            }
        }
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsVector<Character> newPrimitiveVector(char ... cArray) {
        CommonsVector<Character> commonsVector = VectorHelper.newVector();
        if (cArray != null) {
            for (char c : cArray) {
                commonsVector.add(Character.valueOf(c));
            }
        }
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsVector<Double> newPrimitiveVector(double ... dArray) {
        CommonsVector<Double> commonsVector = VectorHelper.newVector();
        if (dArray != null) {
            for (double d : dArray) {
                commonsVector.add(d);
            }
        }
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsVector<Float> newPrimitiveVector(float ... fArray) {
        CommonsVector<Float> commonsVector = VectorHelper.newVector();
        if (fArray != null) {
            for (float f : fArray) {
                commonsVector.add(Float.valueOf(f));
            }
        }
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsVector<Integer> newPrimitiveVector(int ... nArray) {
        CommonsVector<Integer> commonsVector = VectorHelper.newVector();
        if (nArray != null) {
            for (int n : nArray) {
                commonsVector.add(n);
            }
        }
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsVector<Long> newPrimitiveVector(long ... lArray) {
        CommonsVector<Long> commonsVector = VectorHelper.newVector();
        if (lArray != null) {
            for (long l : lArray) {
                commonsVector.add(l);
            }
        }
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsVector<Short> newPrimitiveVector(short ... sArray) {
        CommonsVector<Short> commonsVector = VectorHelper.newVector();
        if (sArray != null) {
            for (short s : sArray) {
                commonsVector.add(s);
            }
        }
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsHashSet<Boolean> newPrimitiveSet(boolean ... blArray) {
        CommonsHashSet<Boolean> commonsHashSet = CollectionHelper.newSet();
        if (blArray != null) {
            for (boolean bl : blArray) {
                commonsHashSet.add(bl);
            }
        }
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsHashSet<Byte> newPrimitiveSet(byte ... byArray) {
        CommonsHashSet<Byte> commonsHashSet = CollectionHelper.newSet();
        if (byArray != null) {
            for (byte by : byArray) {
                commonsHashSet.add(by);
            }
        }
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsHashSet<Character> newPrimitiveSet(char ... cArray) {
        CommonsHashSet<Character> commonsHashSet = CollectionHelper.newSet();
        if (cArray != null) {
            for (char c : cArray) {
                commonsHashSet.add(Character.valueOf(c));
            }
        }
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsHashSet<Double> newPrimitiveSet(double ... dArray) {
        CommonsHashSet<Double> commonsHashSet = CollectionHelper.newSet();
        if (dArray != null) {
            for (double d : dArray) {
                commonsHashSet.add(d);
            }
        }
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsHashSet<Float> newPrimitiveSet(float ... fArray) {
        CommonsHashSet<Float> commonsHashSet = CollectionHelper.newSet();
        if (fArray != null) {
            for (float f : fArray) {
                commonsHashSet.add(Float.valueOf(f));
            }
        }
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsHashSet<Integer> newPrimitiveSet(int ... nArray) {
        CommonsHashSet<Integer> commonsHashSet = CollectionHelper.newSet();
        if (nArray != null) {
            for (int n : nArray) {
                commonsHashSet.add(n);
            }
        }
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsHashSet<Long> newPrimitiveSet(long ... lArray) {
        CommonsHashSet<Long> commonsHashSet = CollectionHelper.newSet();
        if (lArray != null) {
            for (long l : lArray) {
                commonsHashSet.add(l);
            }
        }
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsHashSet<Short> newPrimitiveSet(short ... sArray) {
        CommonsHashSet<Short> commonsHashSet = CollectionHelper.newSet();
        if (sArray != null) {
            for (short s : sArray) {
                commonsHashSet.add(s);
            }
        }
        return commonsHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsLinkedHashSet<Boolean> newPrimitiveOrderedSet(boolean ... blArray) {
        CommonsLinkedHashSet<Boolean> commonsLinkedHashSet = CollectionHelper.newOrderedSet();
        if (blArray != null) {
            for (boolean bl : blArray) {
                commonsLinkedHashSet.add(bl);
            }
        }
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsLinkedHashSet<Byte> newPrimitiveOrderedSet(byte ... byArray) {
        CommonsLinkedHashSet<Byte> commonsLinkedHashSet = CollectionHelper.newOrderedSet();
        if (byArray != null) {
            for (byte by : byArray) {
                commonsLinkedHashSet.add(by);
            }
        }
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsLinkedHashSet<Character> newPrimitiveOrderedSet(char ... cArray) {
        CommonsLinkedHashSet<Character> commonsLinkedHashSet = CollectionHelper.newOrderedSet();
        if (cArray != null) {
            for (char c : cArray) {
                commonsLinkedHashSet.add(Character.valueOf(c));
            }
        }
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsLinkedHashSet<Double> newPrimitiveOrderedSet(double ... dArray) {
        CommonsLinkedHashSet<Double> commonsLinkedHashSet = CollectionHelper.newOrderedSet();
        if (dArray != null) {
            for (double d : dArray) {
                commonsLinkedHashSet.add(d);
            }
        }
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsLinkedHashSet<Float> newPrimitiveOrderedSet(float ... fArray) {
        CommonsLinkedHashSet<Float> commonsLinkedHashSet = CollectionHelper.newOrderedSet();
        if (fArray != null) {
            for (float f : fArray) {
                commonsLinkedHashSet.add(Float.valueOf(f));
            }
        }
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsLinkedHashSet<Integer> newPrimitiveOrderedSet(int ... nArray) {
        CommonsLinkedHashSet<Integer> commonsLinkedHashSet = CollectionHelper.newOrderedSet();
        if (nArray != null) {
            for (int n : nArray) {
                commonsLinkedHashSet.add(n);
            }
        }
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsLinkedHashSet<Long> newPrimitiveOrderedSet(long ... lArray) {
        CommonsLinkedHashSet<Long> commonsLinkedHashSet = CollectionHelper.newOrderedSet();
        if (lArray != null) {
            for (long l : lArray) {
                commonsLinkedHashSet.add(l);
            }
        }
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsLinkedHashSet<Short> newPrimitiveOrderedSet(short ... sArray) {
        CommonsLinkedHashSet<Short> commonsLinkedHashSet = CollectionHelper.newOrderedSet();
        if (sArray != null) {
            for (short s : sArray) {
                commonsLinkedHashSet.add(s);
            }
        }
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsTreeSet<Boolean> newPrimitiveSortedSet(boolean ... blArray) {
        CommonsTreeSet<Boolean> commonsTreeSet = CollectionHelper.newSortedSet();
        if (blArray != null) {
            for (boolean bl : blArray) {
                commonsTreeSet.add(bl);
            }
        }
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsTreeSet<Byte> newPrimitiveSortedSet(byte ... byArray) {
        CommonsTreeSet<Byte> commonsTreeSet = CollectionHelper.newSortedSet();
        if (byArray != null) {
            for (byte by : byArray) {
                commonsTreeSet.add(by);
            }
        }
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsTreeSet<Character> newPrimitiveSortedSet(char ... cArray) {
        CommonsTreeSet<Character> commonsTreeSet = CollectionHelper.newSortedSet();
        if (cArray != null) {
            for (char c : cArray) {
                commonsTreeSet.add(Character.valueOf(c));
            }
        }
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsTreeSet<Double> newPrimitiveSortedSet(double ... dArray) {
        CommonsTreeSet<Double> commonsTreeSet = CollectionHelper.newSortedSet();
        if (dArray != null) {
            for (double d : dArray) {
                commonsTreeSet.add(d);
            }
        }
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsTreeSet<Float> newPrimitiveSortedSet(float ... fArray) {
        CommonsTreeSet<Float> commonsTreeSet = CollectionHelper.newSortedSet();
        if (fArray != null) {
            for (float f : fArray) {
                commonsTreeSet.add(Float.valueOf(f));
            }
        }
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsTreeSet<Integer> newPrimitiveSortedSet(int ... nArray) {
        CommonsTreeSet<Integer> commonsTreeSet = CollectionHelper.newSortedSet();
        if (nArray != null) {
            for (int n : nArray) {
                commonsTreeSet.add(n);
            }
        }
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsTreeSet<Long> newPrimitiveSortedSet(long ... lArray) {
        CommonsTreeSet<Long> commonsTreeSet = CollectionHelper.newSortedSet();
        if (lArray != null) {
            for (long l : lArray) {
                commonsTreeSet.add(l);
            }
        }
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsTreeSet<Short> newPrimitiveSortedSet(short ... sArray) {
        CommonsTreeSet<Short> commonsTreeSet = CollectionHelper.newSortedSet();
        if (sArray != null) {
            for (short s : sArray) {
                commonsTreeSet.add(s);
            }
        }
        return commonsTreeSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static NonBlockingStack<Boolean> newPrimitiveStack(boolean ... blArray) {
        NonBlockingStack<Boolean> nonBlockingStack = StackHelper.newStack();
        if (blArray != null) {
            for (boolean bl : blArray) {
                nonBlockingStack.add(bl);
            }
        }
        return nonBlockingStack;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static NonBlockingStack<Byte> newPrimitiveStack(byte ... byArray) {
        NonBlockingStack<Byte> nonBlockingStack = StackHelper.newStack();
        if (byArray != null) {
            for (byte by : byArray) {
                nonBlockingStack.add(by);
            }
        }
        return nonBlockingStack;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static NonBlockingStack<Character> newPrimitiveStack(char ... cArray) {
        NonBlockingStack<Character> nonBlockingStack = StackHelper.newStack();
        if (cArray != null) {
            for (char c : cArray) {
                nonBlockingStack.add(Character.valueOf(c));
            }
        }
        return nonBlockingStack;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static NonBlockingStack<Double> newPrimitiveStack(double ... dArray) {
        NonBlockingStack<Double> nonBlockingStack = StackHelper.newStack();
        if (dArray != null) {
            for (double d : dArray) {
                nonBlockingStack.add(d);
            }
        }
        return nonBlockingStack;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static NonBlockingStack<Float> newPrimitiveStack(float ... fArray) {
        NonBlockingStack<Float> nonBlockingStack = StackHelper.newStack();
        if (fArray != null) {
            for (float f : fArray) {
                nonBlockingStack.add(Float.valueOf(f));
            }
        }
        return nonBlockingStack;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static NonBlockingStack<Integer> newPrimitiveStack(int ... nArray) {
        NonBlockingStack<Integer> nonBlockingStack = StackHelper.newStack();
        if (nArray != null) {
            for (int n : nArray) {
                nonBlockingStack.add(n);
            }
        }
        return nonBlockingStack;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static NonBlockingStack<Long> newPrimitiveStack(long ... lArray) {
        NonBlockingStack<Long> nonBlockingStack = StackHelper.newStack();
        if (lArray != null) {
            for (long l : lArray) {
                nonBlockingStack.add(l);
            }
        }
        return nonBlockingStack;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static NonBlockingStack<Short> newPrimitiveStack(short ... sArray) {
        NonBlockingStack<Short> nonBlockingStack = StackHelper.newStack();
        if (sArray != null) {
            for (short s : sArray) {
                nonBlockingStack.add(s);
            }
        }
        return nonBlockingStack;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static PriorityQueue<Boolean> newPrimitiveQueue(boolean ... blArray) {
        PriorityQueue<Boolean> priorityQueue = QueueHelper.newQueue();
        if (blArray != null) {
            for (boolean bl : blArray) {
                priorityQueue.add(bl);
            }
        }
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static PriorityQueue<Byte> newPrimitiveQueue(byte ... byArray) {
        PriorityQueue<Byte> priorityQueue = QueueHelper.newQueue();
        if (byArray != null) {
            for (byte by : byArray) {
                priorityQueue.add(by);
            }
        }
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static PriorityQueue<Character> newPrimitiveQueue(char ... cArray) {
        PriorityQueue<Character> priorityQueue = QueueHelper.newQueue();
        if (cArray != null) {
            for (char c : cArray) {
                priorityQueue.add(Character.valueOf(c));
            }
        }
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static PriorityQueue<Double> newPrimitiveQueue(double ... dArray) {
        PriorityQueue<Double> priorityQueue = QueueHelper.newQueue();
        if (dArray != null) {
            for (double d : dArray) {
                priorityQueue.add(d);
            }
        }
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static PriorityQueue<Float> newPrimitiveQueue(float ... fArray) {
        PriorityQueue<Float> priorityQueue = QueueHelper.newQueue();
        if (fArray != null) {
            for (float f : fArray) {
                priorityQueue.add(Float.valueOf(f));
            }
        }
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static PriorityQueue<Integer> newPrimitiveQueue(int ... nArray) {
        PriorityQueue<Integer> priorityQueue = QueueHelper.newQueue();
        if (nArray != null) {
            for (int n : nArray) {
                priorityQueue.add(n);
            }
        }
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static PriorityQueue<Long> newPrimitiveQueue(long ... lArray) {
        PriorityQueue<Long> priorityQueue = QueueHelper.newQueue();
        if (lArray != null) {
            for (long l : lArray) {
                priorityQueue.add(l);
            }
        }
        return priorityQueue;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static PriorityQueue<Short> newPrimitiveQueue(short ... sArray) {
        PriorityQueue<Short> priorityQueue = QueueHelper.newQueue();
        if (sArray != null) {
            for (short s : sArray) {
                priorityQueue.add(s);
            }
        }
        return priorityQueue;
    }
}

