/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scope;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.scope.AbstractMapBasedScope;
import com.helger.commons.scope.IApplicationScope;
import com.helger.commons.scope.ScopeHelper;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ApplicationScope
extends AbstractMapBasedScope
implements IApplicationScope {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ApplicationScope.class);

    public ApplicationScope(@Nonnull @Nonempty String string) {
        super(string);
        if (ScopeHelper.debugApplicationScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Created application scope '" + string + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    public void initScope() {
    }

    @Override
    protected void preDestroy() {
        if (ScopeHelper.debugApplicationScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Destroying application scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    protected void postDestroy() {
        if (ScopeHelper.debugApplicationScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Destroyed application scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }
}

