/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hierarchy.IChildrenProvider;
import com.helger.commons.hierarchy.visit.ChildrenProviderHierarchyVisitor;
import com.helger.commons.hierarchy.visit.IHierarchyVisitorCallback;
import com.helger.commons.microdom.IMicroNode;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MicroVisitor {
    private static final MicroVisitor s_aInstance = new MicroVisitor();

    private MicroVisitor() {
    }

    public static void visit(@Nonnull IMicroNode iMicroNode, @Nonnull IHierarchyVisitorCallback<? super IMicroNode> iHierarchyVisitorCallback) {
        ValueEnforcer.notNull(iMicroNode, "Node");
        ChildrenProviderHierarchyVisitor.visitFrom(iMicroNode, iHierarchyVisitorCallback, false);
    }

    public static <T extends IMicroNode> void visit(@Nonnull T t, @Nonnull IChildrenProvider<T> iChildrenProvider, @Nonnull IHierarchyVisitorCallback<? super T> iHierarchyVisitorCallback) {
        ValueEnforcer.notNull(t, "Node");
        ChildrenProviderHierarchyVisitor.visitFrom(t, iChildrenProvider, iHierarchyVisitorCallback, false);
    }
}

