/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.aggregate.AggregatorStringWithSeparatorIgnoreNull;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.file.filter.IFileFilter;
import com.helger.commons.tree.withid.folder.DefaultFolderTree;
import com.helger.commons.tree.withid.folder.DefaultFolderTreeItem;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FileSystemFolderTree
extends DefaultFolderTree<String, File, List<File>> {
    private static void _iterate(@Nonnull DefaultFolderTreeItem<String, File, List<File>> defaultFolderTreeItem, @Nonnull File file, @Nullable IFileFilter iFileFilter, @Nullable IFileFilter iFileFilter2) {
        if (file != null) {
            for (File file2 : FileHelper.getDirectoryContent(file)) {
                if (file2.isFile()) {
                    if (iFileFilter2 != null && !iFileFilter2.matchesFilter(file2)) continue;
                    ((List)defaultFolderTreeItem.getData()).add(file2);
                    continue;
                }
                if (!file2.isDirectory() || FilenameHelper.isSystemInternalDirectory(file2) || iFileFilter != null && !iFileFilter.matchesFilter(file2)) continue;
                DefaultFolderTreeItem defaultFolderTreeItem2 = (DefaultFolderTreeItem)defaultFolderTreeItem.createChildItem(file2.getName(), (File)((Object)new ArrayList()));
                FileSystemFolderTree._iterate(defaultFolderTreeItem2, file2, iFileFilter, iFileFilter2);
            }
        }
    }

    public FileSystemFolderTree(@Nonnull String string) {
        this(new File(string));
    }

    public FileSystemFolderTree(@Nonnull File file) {
        this(file, (IFileFilter)null, (IFileFilter)null);
    }

    public FileSystemFolderTree(@Nonnull String string, @Nullable IFileFilter iFileFilter, @Nullable IFileFilter iFileFilter2) {
        this(new File(string), iFileFilter, iFileFilter2);
    }

    public FileSystemFolderTree(@Nonnull File file, @Nullable IFileFilter iFileFilter, @Nullable IFileFilter iFileFilter2) {
        super(new AggregatorStringWithSeparatorIgnoreNull("/"));
        ValueEnforcer.notNull(file, "StartDirectory");
        ValueEnforcer.isTrue(file.isDirectory(), "Start directory is not a directory!");
        DefaultFolderTreeItem defaultFolderTreeItem = (DefaultFolderTreeItem)((DefaultFolderTreeItem)this.getRootItem()).createChildItem(file.getName(), new ArrayList());
        FileSystemFolderTree._iterate(defaultFolderTreeItem, file, iFileFilter, iFileFilter2);
    }
}

