/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file.filter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.file.filter.AbstractFileFilter;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.io.FilenameFilter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FileFilterFromFilenameFilter
extends AbstractFileFilter {
    private final FilenameFilter m_aFilenameFilter;

    public FileFilterFromFilenameFilter(@Nonnull FilenameFilter filenameFilter) {
        this.m_aFilenameFilter = ValueEnforcer.notNull(filenameFilter, "FilenameFilter");
    }

    @Nonnull
    public FilenameFilter getFilenameFilter() {
        return this.m_aFilenameFilter;
    }

    @Override
    public boolean matchesThisFilter(@Nullable File file) {
        return file != null && this.m_aFilenameFilter.accept(file.getParentFile(), file.getName());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("FilenameFilter", this.m_aFilenameFilter).toString();
    }
}

