/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.compare;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.compare.AbstractComparator;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.string.ToStringGenerator;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractPartComparator<DATATYPE, PARTTYPE>
extends AbstractComparator<DATATYPE> {
    private final Comparator<? super PARTTYPE> m_aPartComparator;

    public AbstractPartComparator(@Nonnull Comparator<? super PARTTYPE> comparator) {
        this.m_aPartComparator = ValueEnforcer.notNull(comparator, "PartComparator");
    }

    @Nonnull
    public final Comparator<? super PARTTYPE> getPartComparator() {
        return this.m_aPartComparator;
    }

    @Nullable
    protected abstract PARTTYPE getPart(@Nonnull DATATYPE var1);

    @Override
    protected final int mainCompare(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        PARTTYPE PARTTYPE = this.getPart(DATATYPE);
        PARTTYPE PARTTYPE2 = this.getPart(DATATYPE2);
        return CompareHelper.compare(PARTTYPE, PARTTYPE2, this.m_aPartComparator, this.isNullValuesComeFirst());
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("partComparator", this.m_aPartComparator).toString();
    }
}

