/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.codec;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.codec.AbstractByteArrayCodec;
import com.helger.commons.codec.DecodeException;
import com.helger.commons.codec.EncodeException;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlateCodec
extends AbstractByteArrayCodec {
    private static final Logger s_aLogger = LoggerFactory.getLogger(FlateCodec.class);

    public static boolean isZlibHead(@Nonnull byte[] byArray) {
        if (byArray.length >= 2) {
            int n = byArray[0] & 0xFF;
            int n2 = byArray[1] & 0xFF;
            if ((n & 0xF) == 8 && (n >> 4) + 8 <= 15 && ((n << 8) + n2) % 31 == 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @ReturnsMutableCopy
    public static byte[] getDecodedFlate(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (!FlateCodec.isZlibHead(byArray)) {
            s_aLogger.warn("ZLib header not found");
        }
        InflaterInputStream inflaterInputStream = new InflaterInputStream(new NonBlockingByteArrayInputStream(byArray));
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
        try {
            if (StreamHelper.copyInputStreamToOutputStream(inflaterInputStream, nonBlockingByteArrayOutputStream).isFailure()) {
                throw new DecodeException("Failed to flate decode!");
            }
            byte[] byArray2 = nonBlockingByteArrayOutputStream.toByteArray();
            return byArray2;
        }
        finally {
            StreamHelper.close(nonBlockingByteArrayOutputStream);
        }
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public byte[] getDecoded(@Nullable byte[] byArray) {
        return FlateCodec.getDecodedFlate(byArray);
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getEncodedFlate(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(nonBlockingByteArrayOutputStream);
        if (StreamHelper.copyInputStreamToOutputStreamAndCloseOS(new NonBlockingByteArrayInputStream(byArray), deflaterOutputStream).isFailure()) {
            throw new EncodeException("Failed to flate encode!");
        }
        return nonBlockingByteArrayOutputStream.toByteArray();
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public byte[] getEncoded(@Nullable byte[] byArray) {
        return FlateCodec.getEncodedFlate(byArray);
    }
}

