/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.util;

import com.googlecode.mp4parser.util.Logger;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyList<E>
extends AbstractList<E> {
    private static final Logger LOG = Logger.getLogger(LazyList.class);
    List<E> underlying;
    Iterator<E> elementSource;

    public LazyList(List<E> underlying, Iterator<E> elementSource) {
        this.underlying = underlying;
        this.elementSource = elementSource;
    }

    public List<E> getUnderlying() {
        return this.underlying;
    }

    private void blowup() {
        LOG.logDebug("blowup running");
        while (this.elementSource.hasNext()) {
            this.underlying.add(this.elementSource.next());
        }
    }

    @Override
    public E get(int i) {
        if (this.underlying.size() > i) {
            return this.underlying.get(i);
        }
        if (this.elementSource.hasNext()) {
            this.underlying.add(this.elementSource.next());
            return this.get(i);
        }
        throw new NoSuchElementException();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < LazyList.this.underlying.size() || LazyList.this.elementSource.hasNext();
            }

            @Override
            public E next() {
                if (this.pos < LazyList.this.underlying.size()) {
                    return LazyList.this.underlying.get(this.pos++);
                }
                LazyList.this.underlying.add(LazyList.this.elementSource.next());
                return this.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        LOG.logDebug("potentially expensive size() call");
        this.blowup();
        return this.underlying.size();
    }
}

