/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.cp.storage;

import com.binarywang.spring.starter.wxjava.cp.properties.WxCpProperties;
import com.binarywang.spring.starter.wxjava.cp.storage.AbstractWxCpConfigStorageConfiguration;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import me.chanjar.weixin.cp.config.impl.WxCpDefaultConfigImpl;
import me.chanjar.weixin.cp.config.impl.WxCpRedisTemplateConfigImpl;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
@ConditionalOnProperty(prefix="wx.cp.config-storage", name={"type"}, havingValue="redistemplate")
public class WxCpInRedisTemplateConfigStorageConfiguration
extends AbstractWxCpConfigStorageConfiguration {
    private final WxCpProperties wxCpProperties;
    private final ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean(value={WxCpConfigStorage.class})
    public WxCpConfigStorage wxCpConfigStorage() {
        WxCpRedisTemplateConfigImpl config = this.getConfigStorage();
        return this.config((WxCpDefaultConfigImpl)config, this.wxCpProperties);
    }

    private WxCpRedisTemplateConfigImpl getConfigStorage() {
        StringRedisTemplate redisTemplate = (StringRedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
        return new WxCpRedisTemplateConfigImpl(redisTemplate, this.wxCpProperties.getConfigStorage().getKeyPrefix());
    }

    public WxCpInRedisTemplateConfigStorageConfiguration(WxCpProperties wxCpProperties, ApplicationContext applicationContext) {
        this.wxCpProperties = wxCpProperties;
        this.applicationContext = applicationContext;
    }
}

