/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.cp.config;

import com.binarywang.spring.starter.wxjava.cp.properties.WxCpProperties;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.api.impl.WxCpServiceImpl;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WxCpServiceAutoConfiguration {
    private final WxCpProperties wxCpProperties;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={WxCpConfigStorage.class})
    public WxCpService wxCpService(WxCpConfigStorage wxCpConfigStorage) {
        int retrySleepMillis;
        WxCpServiceImpl wxCpService = new WxCpServiceImpl();
        wxCpService.setWxCpConfigStorage(wxCpConfigStorage);
        WxCpProperties.ConfigStorage storage = this.wxCpProperties.getConfigStorage();
        int maxRetryTimes = storage.getMaxRetryTimes();
        if (maxRetryTimes < 0) {
            maxRetryTimes = 0;
        }
        if ((retrySleepMillis = storage.getRetrySleepMillis()) < 0) {
            retrySleepMillis = 1000;
        }
        wxCpService.setRetrySleepMillis(retrySleepMillis);
        wxCpService.setMaxRetryTimes(maxRetryTimes);
        return wxCpService;
    }

    public WxCpServiceAutoConfiguration(WxCpProperties wxCpProperties) {
        this.wxCpProperties = wxCpProperties;
    }
}

