/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaLiveService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.live.WxMaAssistantResult;
import cn.binarywang.wx.miniapp.bean.live.WxMaCreateRoomResult;
import cn.binarywang.wx.miniapp.bean.live.WxMaLiveAssistantInfo;
import cn.binarywang.wx.miniapp.bean.live.WxMaLiveResult;
import cn.binarywang.wx.miniapp.bean.live.WxMaLiveRoomInfo;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import com.google.common.base.Joiner;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaLiveServiceImpl
implements WxMaLiveService {
    private static final Logger log = LoggerFactory.getLogger(WxMaLiveServiceImpl.class);
    private static final String ERR_CODE = "errcode";
    private static final String ROOM_ID = "roomId";
    private final WxMaService wxMaService;

    @Override
    public WxMaCreateRoomResult createRoom(WxMaLiveRoomInfo roomInfo) throws WxErrorException {
        try {
            String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/room/create", WxMaGsonBuilder.create().toJson((Object)roomInfo));
            JsonObject jsonObject = GsonParser.parse((String)responseContent);
            if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
                throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
            }
            return (WxMaCreateRoomResult)WxMaGsonBuilder.create().fromJson(responseContent, WxMaCreateRoomResult.class);
        }
        catch (WxErrorException e) {
            if (e.getError().getErrorCode() == 300036) {
                return (WxMaCreateRoomResult)WxMaGsonBuilder.create().fromJson(e.getError().getJson(), WxMaCreateRoomResult.class);
            }
            throw e;
        }
    }

    @Override
    public boolean deleteRoom(Integer roomId) throws WxErrorException {
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        map.put("id", roomId);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/room/deleteroom", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return true;
    }

    @Override
    public boolean editRoom(WxMaLiveRoomInfo roomInfo) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/room/editroom", WxMaGsonBuilder.create().toJson((Object)roomInfo));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return true;
    }

    @Override
    public String getPushUrl(Integer roomId) throws WxErrorException {
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        map.put(ROOM_ID, roomId);
        String responseContent = this.wxMaService.get("https://api.weixin.qq.com/wxaapi/broadcast/room/getpushurl", Joiner.on((String)"&").withKeyValueSeparator("=").join(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return jsonObject.get("pushAddr").getAsString();
    }

    @Override
    public String getSharedCode(Integer roomId, String params) throws WxErrorException {
        String responseContent;
        JsonObject jsonObject;
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put(ROOM_ID, roomId);
        if (null != params) {
            map.put("params", params);
        }
        if ((jsonObject = GsonParser.parse((String)(responseContent = this.wxMaService.get("https://api.weixin.qq.com/wxaapi/broadcast/room/getsharedcode", Joiner.on((String)"&").withKeyValueSeparator("=").join(map))))).get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return jsonObject.get("cdnUrl").getAsString();
    }

    @Override
    public List<WxMaLiveResult.RoomInfo> getLiveInfos() throws WxErrorException {
        ArrayList<WxMaLiveResult.RoomInfo> results = new ArrayList<WxMaLiveResult.RoomInfo>();
        int start = 0;
        Integer limit = 80;
        Integer total = 0;
        while (total == 0 || total > start) {
            WxMaLiveResult liveInfo = this.getLiveInfo(start, limit);
            if (liveInfo == null) {
                return null;
            }
            results.addAll(liveInfo.getRoomInfos());
            total = liveInfo.getTotal();
            start = results.size();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                log.error("InterruptedException", (Throwable)e);
            }
            if (results.size() <= total) continue;
        }
        return results;
    }

    @Override
    public WxMaLiveResult getLiveInfo(Integer start, Integer limit) throws WxErrorException {
        JsonObject jsonObject = this.getLiveInfo(start, limit, null);
        return WxMaLiveResult.fromJson(jsonObject.toString());
    }

    @Override
    public WxMaLiveResult getLiveReplay(String action, Integer roomId, Integer start, Integer limit) throws WxErrorException {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("action", action);
        map.put("room_id", roomId);
        JsonObject jsonObject = this.getLiveInfo(start, limit, map);
        return WxMaLiveResult.fromJson(jsonObject.toString());
    }

    private JsonObject getLiveInfo(Integer start, Integer limit, Map<String, Object> map) throws WxErrorException {
        if (map == null) {
            map = new HashMap<String, Object>(2);
        }
        map.put("start", start);
        map.put("limit", limit);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxa/business/getliveinfo", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return jsonObject;
    }

    @Override
    public WxMaLiveResult getLiveReplay(Integer roomId, Integer start, Integer limit) throws WxErrorException {
        return this.getLiveReplay("get_replay", roomId, start, limit);
    }

    @Override
    public boolean addGoodsToRoom(Integer roomId, List<Integer> goodsIds) throws WxErrorException {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put(ROOM_ID, roomId);
        map.put("ids", goodsIds);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/room/addgoods", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return true;
    }

    @Override
    public boolean addAssistant(Integer roomId, List<WxMaLiveAssistantInfo> users) throws WxErrorException {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put(ROOM_ID, roomId);
        map.put("users", users);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/room/addassistant", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return true;
    }

    @Override
    public boolean modifyAssistant(Integer roomId, String username, String nickname) throws WxErrorException {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put(ROOM_ID, roomId);
        map.put("username", username);
        map.put("nickname", nickname);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/room/modifyassistant", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return true;
    }

    @Override
    public boolean removeAssistant(Integer roomId, String username) throws WxErrorException {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put(ROOM_ID, roomId);
        map.put("username", username);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/room/removeassistant", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return true;
    }

    @Override
    public List<WxMaAssistantResult.Assistant> getAssistantList(Integer roomId) throws WxErrorException {
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        map.put(ROOM_ID, roomId);
        String responseContent = this.wxMaService.get("https://api.weixin.qq.com/wxaapi/broadcast/room/getassistantlist", Joiner.on((String)"&").withKeyValueSeparator("=").join(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return WxMaAssistantResult.fromJson(responseContent).getList();
    }

    @Override
    public boolean addSubanchor(Integer roomId, String username) throws WxErrorException {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put(ROOM_ID, roomId);
        map.put("username", username);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/room/addsubanchor", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return true;
    }

    @Override
    public boolean modifySubanchor(Integer roomId, String username) throws WxErrorException {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put(ROOM_ID, roomId);
        map.put("username", username);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/room/modifysubanchor", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return true;
    }

    @Override
    public boolean deleteSubanchor(Integer roomId) throws WxErrorException {
        HashMap<String, Integer> map = new HashMap<String, Integer>(1);
        map.put(ROOM_ID, roomId);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/room/deletesubanchor", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return true;
    }

    @Override
    public String getSubanchor(Integer roomId) throws WxErrorException {
        HashMap<String, Integer> map = new HashMap<String, Integer>(1);
        map.put(ROOM_ID, roomId);
        String responseContent = this.wxMaService.get("https://api.weixin.qq.com/wxaapi/broadcast/room/getsubanchor", Joiner.on((String)"&").withKeyValueSeparator("=").join(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return jsonObject.get("username").getAsString();
    }

    @Override
    public boolean updatefeedpublic(Integer roomId, Integer isFeedsPublic) throws WxErrorException {
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        map.put(ROOM_ID, roomId);
        map.put("isFeedsPublic", isFeedsPublic);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/room/updatefeedpublic", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return true;
    }

    @Override
    public boolean updatereplay(Integer roomId, Integer closeReplay) throws WxErrorException {
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        map.put(ROOM_ID, roomId);
        map.put("closeReplay", closeReplay);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/room/updatereplay", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return true;
    }

    @Override
    public boolean updatekf(Integer roomId, Integer closeKf) throws WxErrorException {
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        map.put(ROOM_ID, roomId);
        map.put("closeKf", closeKf);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/room/updatekf", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return true;
    }

    @Override
    public boolean updatecomment(Integer roomId, Integer banComment) throws WxErrorException {
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        map.put(ROOM_ID, roomId);
        map.put("banComment", banComment);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/room/updatecomment", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return true;
    }

    @Override
    public boolean onsale(Integer roomId, Integer goodsId, Integer onSale) throws WxErrorException {
        HashMap<String, Integer> map = new HashMap<String, Integer>(3);
        map.put(ROOM_ID, roomId);
        map.put("goodsId", goodsId);
        map.put("onSale", onSale);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/goods/onsale", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return true;
    }

    @Override
    public boolean deleteInRoom(Integer roomId, Integer goodsId) throws WxErrorException {
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        map.put(ROOM_ID, roomId);
        map.put("goodsId", goodsId);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/goods/deleteInRoom", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return true;
    }

    @Override
    public boolean push(Integer roomId, Integer goodsId) throws WxErrorException {
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        map.put(ROOM_ID, roomId);
        map.put("goodsId", goodsId);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/goods/push", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return true;
    }

    @Override
    public boolean sort(Integer roomId, List<Map<String, String>> goods) throws WxErrorException {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put(ROOM_ID, roomId);
        map.put("goods", goods);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/goods/sort", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return true;
    }

    @Override
    public String getVideo(Integer roomId, Integer goodsId) throws WxErrorException {
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        map.put(ROOM_ID, roomId);
        map.put("goodsId", goodsId);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/wxaapi/broadcast/goods/getVideo", WxMaGsonBuilder.create().toJson(map));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return jsonObject.get("url").getAsString();
    }

    public WxMaLiveServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

