/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.locks;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.core.types.Expiration;

public class RedisTemplateSimpleDistributedLock
implements Lock {
    private final StringRedisTemplate redisTemplate;
    private final String key;
    private final int leaseMilliseconds;
    private final ThreadLocal<String> valueThreadLocal = new ThreadLocal();

    public RedisTemplateSimpleDistributedLock(@NonNull StringRedisTemplate redisTemplate, int leaseMilliseconds) {
        this(redisTemplate, "lock:" + UUID.randomUUID().toString(), leaseMilliseconds);
        if (redisTemplate == null) {
            throw new NullPointerException("redisTemplate is marked non-null but is null");
        }
    }

    public RedisTemplateSimpleDistributedLock(@NonNull StringRedisTemplate redisTemplate, @NonNull String key, int leaseMilliseconds) {
        if (redisTemplate == null) {
            throw new NullPointerException("redisTemplate is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (leaseMilliseconds <= 0) {
            throw new IllegalArgumentException("Parameter 'leaseMilliseconds' must grate then 0: " + leaseMilliseconds);
        }
        this.redisTemplate = redisTemplate;
        this.key = key;
        this.leaseMilliseconds = leaseMilliseconds;
    }

    @Override
    public void lock() {
        while (!this.tryLock()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        while (!this.tryLock()) {
            Thread.sleep(1000L);
        }
    }

    @Override
    public boolean tryLock() {
        byte[] valueBytes;
        byte[] keyBytes;
        List redisResults;
        String value = this.valueThreadLocal.get();
        if (value == null || value.length() == 0) {
            value = UUID.randomUUID().toString();
            this.valueThreadLocal.set(value);
        }
        Object currentLockSecret = (redisResults = this.redisTemplate.executePipelined((RedisCallback)new RedisCallback<String>(keyBytes = this.key.getBytes(StandardCharsets.UTF_8), valueBytes = value.getBytes(StandardCharsets.UTF_8)){
            final /* synthetic */ byte[] val$keyBytes;
            final /* synthetic */ byte[] val$valueBytes;
            {
                this.val$keyBytes = byArray;
                this.val$valueBytes = byArray2;
            }

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                connection.set(this.val$keyBytes, this.val$valueBytes, Expiration.milliseconds((long)RedisTemplateSimpleDistributedLock.this.leaseMilliseconds), RedisStringCommands.SetOption.SET_IF_ABSENT);
                connection.get(this.val$keyBytes);
                return null;
            }
        })).size() > 1 ? redisResults.get(1) : redisResults.get(0);
        return currentLockSecret != null && currentLockSecret.toString().equals(value);
    }

    @Override
    public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
        long sleep;
        boolean locked = this.tryLock();
        for (long waitMs = unit.toMillis(time); !locked && waitMs > 0L; waitMs -= sleep) {
            sleep = waitMs < 1000L ? waitMs : 1000L;
            Thread.sleep(sleep);
            locked = this.tryLock();
        }
        return locked;
    }

    @Override
    public void unlock() {
        if (this.valueThreadLocal.get() != null) {
            DefaultRedisScript script = new DefaultRedisScript("if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end", Long.class);
            this.redisTemplate.execute((RedisScript)script, Arrays.asList(this.key), new Object[]{this.valueThreadLocal.get()});
            this.valueThreadLocal.remove();
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    public String getLockSecretValue() {
        return this.valueThreadLocal.get();
    }

    public StringRedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public String getKey() {
        return this.key;
    }

    public int getLeaseMilliseconds() {
        return this.leaseMilliseconds;
    }
}

