/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessFileReader
extends RandomAccessReader {
    @NotNull
    private final RandomAccessFile _file;
    private final long _length;
    private int _currentIndex;

    @SuppressWarnings(value="EI_EXPOSE_REP2", justification="Design intent")
    public RandomAccessFileReader(@NotNull RandomAccessFile file) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        this._file = file;
        this._length = this._file.length();
    }

    public long getLength() {
        return this._length;
    }

    protected byte getByte(int index) throws IOException {
        int b;
        if (index != this._currentIndex) {
            this.seek(index);
        }
        if ((b = this._file.read()) < 0) {
            throw new BufferBoundsException("Unexpected end of file encountered.");
        }
        assert (b <= 255);
        ++this._currentIndex;
        return (byte)b;
    }

    @NotNull
    public byte[] getBytes(int index, int count) throws IOException {
        this.validateIndex(index, count);
        if (index != this._currentIndex) {
            this.seek(index);
        }
        byte[] bytes = new byte[count];
        int bytesRead = this._file.read(bytes);
        this._currentIndex += bytesRead;
        if (bytesRead != count) {
            throw new BufferBoundsException("Unexpected end of file encountered.");
        }
        return bytes;
    }

    private void seek(int index) throws IOException {
        if (index == this._currentIndex) {
            return;
        }
        this._file.seek(index);
        this._currentIndex = index;
    }

    protected boolean isValidIndex(int index, int bytesRequested) throws IOException {
        return bytesRequested >= 0 && index >= 0 && (long)index + (long)bytesRequested - 1L < this._length;
    }

    protected void validateIndex(int index, int bytesRequested) throws IOException {
        if (!this.isValidIndex(index, bytesRequested)) {
            throw new BufferBoundsException(index, bytesRequested, this._length);
        }
    }
}

