/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.aop.service.impl;

import com.codingapi.tx.Constants;
import com.codingapi.tx.aop.bean.TxTransactionInfo;
import com.codingapi.tx.aop.bean.TxTransactionLocal;
import com.codingapi.tx.aop.service.TransactionServer;
import com.lorne.core.framework.utils.KidUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="txRunningNoTransactionServer")
public class TxRunningNoTransactionServerImpl
implements TransactionServer {
    private Logger logger = LoggerFactory.getLogger(TxRunningNoTransactionServerImpl.class);

    @Override
    public Object execute(ProceedingJoinPoint point, TxTransactionInfo info) throws Throwable {
        String kid = KidUtils.generateShortUuid();
        String txGroupId = info.getTxGroupId();
        this.logger.debug("--->begin no db transaction, groupId: " + txGroupId);
        long t1 = System.currentTimeMillis();
        TxTransactionLocal txTransactionLocal = new TxTransactionLocal();
        txTransactionLocal.setGroupId(txGroupId);
        txTransactionLocal.setHasStart(false);
        txTransactionLocal.setKid(kid);
        txTransactionLocal.setMaxTimeOut(Constants.txServer.getCompensateMaxWaitTime());
        TxTransactionLocal.setCurrent(txTransactionLocal);
        try {
            Object object = point.proceed();
            return object;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            TxTransactionLocal.setCurrent(null);
            long t2 = System.currentTimeMillis();
            this.logger.debug("<---end no db transaction,groupId:" + txGroupId + ",execute time:" + (t2 - t1));
        }
    }
}

