/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf.code;

import com.baidu.bjf.remoting.protobuf.FieldType;
import com.baidu.bjf.remoting.protobuf.annotation.Protobuf;
import com.baidu.bjf.remoting.protobuf.annotation.ProtobufClass;
import com.baidu.bjf.remoting.protobuf.code.CodedConstant;
import com.baidu.bjf.remoting.protobuf.code.ICodeGenerator;
import com.baidu.bjf.remoting.protobuf.utils.ClassHelper;
import com.baidu.bjf.remoting.protobuf.utils.FieldInfo;
import com.baidu.bjf.remoting.protobuf.utils.FieldUtils;
import com.baidu.bjf.remoting.protobuf.utils.ProtobufProxyUtils;
import com.baidu.bjf.remoting.protobuf.utils.StringUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractCodeGenerator
implements ICodeGenerator {
    private static final Logger LOGGER = Logger.getLogger(AbstractCodeGenerator.class.getCanonicalName());
    protected boolean debug = false;
    protected File outputPath;
    protected Class<?> cls;
    private String targetProxyClassname;
    protected List<FieldInfo> fields;

    public AbstractCodeGenerator(Class<?> cls) {
        this.cls = cls;
        this.targetProxyClassname = ClassHelper.getInternalName(cls.getCanonicalName());
        this.fields = this.fetchFieldInfos();
    }

    protected List<FieldInfo> fetchFieldInfos() {
        ProtobufClass annotation = this.cls.getAnnotation(ProtobufClass.class);
        boolean typeDefined = false;
        List<Field> fields = null;
        if (annotation == null) {
            fields = FieldUtils.findMatchedFields(this.cls, Protobuf.class);
            if (fields.isEmpty()) {
                throw new IllegalArgumentException("Invalid class [" + this.cls.getName() + "] no field use annotation @" + Protobuf.class.getName() + " at class " + this.cls.getName());
            }
        } else {
            typeDefined = true;
            fields = FieldUtils.findMatchedFields(this.cls, null);
        }
        List<FieldInfo> fieldInfos = ProtobufProxyUtils.processDefaultValue(fields, typeDefined);
        return fieldInfos;
    }

    protected String getTargetProxyClassname() {
        return this.targetProxyClassname;
    }

    @Override
    public void setOutputPath(File outputPath) {
        this.outputPath = outputPath;
    }

    protected File getOutputPath() {
        return this.outputPath;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public String getClassName() {
        return ClassHelper.getClassName(this.cls);
    }

    @Override
    public String getPackage() {
        return ClassHelper.getPackage(this.cls);
    }

    @Override
    public String getFullClassName() {
        if (StringUtils.isEmpty(this.getPackage())) {
            return this.getClassName();
        }
        return this.getPackage() + "." + this.getClassName();
    }

    protected void checkType(FieldType type, Field field) {
        Class<?> cls = field.getType();
        if (type == FieldType.OBJECT || type == FieldType.ENUM) {
            return;
        }
        String javaType = type.getJavaType();
        if (Integer.class.getSimpleName().equals(javaType)) {
            if (cls.getSimpleName().equals("int") || Integer.class.getSimpleName().equals(cls.getSimpleName())) {
                return;
            }
            throw new IllegalArgumentException(this.getMismatchTypeErroMessage(type, field));
        }
        if (!javaType.equalsIgnoreCase(cls.getSimpleName())) {
            throw new IllegalArgumentException(this.getMismatchTypeErroMessage(type, field));
        }
    }

    private String getMismatchTypeErroMessage(FieldType type, Field field) {
        return "Type mismatch. @Protobuf required type '" + type.getJavaType() + "' but field type is '" + field.getType().getSimpleName() + "' of field name '" + field.getName() + "' on class " + field.getDeclaringClass().getCanonicalName();
    }

    protected String getAccessByField(String target, Field field, Class<?> cls) {
        if (field.getModifiers() == 1) {
            return target + "." + field.getName();
        }
        String getter = "boolean".equalsIgnoreCase(field.getType().getCanonicalName()) ? "is" + CodedConstant.capitalize(field.getName()) : "get" + CodedConstant.capitalize(field.getName());
        try {
            cls.getMethod(getter, new Class[0]);
            return target + "." + getter + "()";
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, e.getMessage(), e);
            String type = field.getType().getCanonicalName();
            if ("[B".equals(type) || "[Ljava.lang.Byte;".equals(type) || "java.lang.Byte[]".equals(type)) {
                type = "byte[]";
            }
            String code = "(" + FieldUtils.toObjectType(type) + ") ";
            code = code + "FieldUtils.getField(" + target + ", \"" + field.getName() + "\")";
            return code;
        }
    }
}

