/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.request;

import com.aliyun.openservices.log.request.Request;

public class GetLogsRequest
extends Request {
    private static final long serialVersionUID = -484272901258629068L;
    private String mLogStore;

    public GetLogsRequest(String project, String logStore, int from, int to, String topic, String query) {
        super(project);
        this.mLogStore = logStore;
        this.SetTopic(topic);
        this.SetQuery(query);
        this.SetFromTime(from);
        this.SetToTime(to);
        this.SetParam("type", "log");
    }

    public GetLogsRequest(String project, String logStore, int from, int to, String topic, String query, long offset, long line, boolean reverse) {
        this(project, logStore, from, to, topic, query);
        this.SetOffset(offset);
        this.SetLine(line);
        this.SetReverse(reverse);
    }

    public GetLogsRequest(String project, String logStore, int from, int to, String topic, String query, long offset, long line, boolean reverse, boolean powerSql) {
        this(project, logStore, from, to, topic, query);
        this.SetOffset(offset);
        this.SetLine(line);
        this.SetReverse(reverse);
        this.SetPowerSql(powerSql);
    }

    public GetLogsRequest(String project, String logStore, int from, int to, String topic, String query, long offset, long line, boolean reverse, boolean powerSql, boolean forward) {
        this(project, logStore, from, to, topic, query);
        this.SetOffset(offset);
        this.SetLine(line);
        this.SetReverse(reverse);
        this.SetPowerSql(powerSql);
        this.SetForward(forward);
    }

    public GetLogsRequest(String project, String logStore, int from, int to, String topic, String query, long offset, long line, boolean reverse, int shard) {
        this(project, logStore, from, to, topic, query, offset, line, reverse);
        this.SetShard(shard);
    }

    public GetLogsRequest(String project, String logStore, int from, int to, String topic, String query, long offset, long line, boolean reverse, boolean forward, String session) {
        this(project, logStore, from, to, topic, query, offset, line, reverse);
        this.SetForward(forward);
        this.SetSession(session);
    }

    public void SetLogStore(String logStore) {
        this.mLogStore = logStore;
    }

    public String GetLogStore() {
        return this.mLogStore;
    }

    public void SetTopic(String topic) {
        this.SetParam("topic", topic);
    }

    public String GetTopic() {
        return this.GetParam("topic");
    }

    public void SetQuery(String query) {
        this.SetParam("query", query);
    }

    public String GetQuery() {
        return this.GetParam("query");
    }

    public void SetFromTime(int from) {
        this.SetParam("from", String.valueOf(from));
    }

    public int GetFromTime() {
        String from = this.GetParam("from");
        if (from.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(from);
    }

    public void SetToTime(int to) {
        this.SetParam("to", String.valueOf(to));
    }

    public int GetToTime() {
        String to = this.GetParam("to");
        if (to.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(to);
    }

    public void SetOffset(long offset) {
        this.SetParam("offset", String.valueOf(offset));
    }

    public long GetOffset() {
        String offset = this.GetParam("offset");
        if (offset.isEmpty()) {
            return 0L;
        }
        return Long.parseLong(offset);
    }

    public void SetLine(long line) {
        this.SetParam("line", String.valueOf(line));
    }

    public long GetLine() {
        String line = this.GetParam("line");
        if (line.isEmpty()) {
            return 0L;
        }
        return Long.parseLong(line);
    }

    public void SetReverse(boolean reverse) {
        this.SetParam("reverse", String.valueOf(reverse));
    }

    public boolean GetReverse() {
        String reverse = this.GetParam("reverse");
        if (reverse.isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(reverse);
    }

    public void SetPowerSql(boolean powerSql) {
        this.SetParam("powerSql", String.valueOf(powerSql));
    }

    public void SetShard(int shard) {
        this.SetParam("shard", String.valueOf(shard));
    }

    public void SetSession(String session) {
        if (session != null) {
            this.SetParam("session", session);
        }
    }

    public boolean GetPowerSql() {
        String powerSql = this.GetParam("powerSql");
        if (powerSql.isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(powerSql);
    }

    public void SetForward(boolean forward) {
        this.SetParam("forward", String.valueOf(forward));
    }

    public boolean GetForward() {
        String forward = this.GetParam("forward");
        if (forward.isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(forward);
    }
}

