/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.http.utils;

import com.aliyun.openservices.log.exception.LogException;
import java.util.regex.Pattern;

public class CodingUtils {
    private static final Pattern PROJECT_PATTERN = Pattern.compile("^[0-9a-zA-Z-_]{1,128}$");
    private static final Pattern CONSUMER_GROUP_PATTERN = Pattern.compile("^[0-9a-zA-Z-_]{1,128}$");
    private static final Pattern DASHBOARD_PATTERN = Pattern.compile("^[0-9a-z][0-9a-z_-]{0,126}[0-9a-z]$");
    private static final Pattern LOGSTORE_PATTERN = Pattern.compile("^[0-9a-z][0-9a-z_-]{0,62}[0-9a-z]$");
    private static final Pattern METASTORE_PATTERN = Pattern.compile("^[a-z][0-9a-z_.]{1,125}[0-9a-z]$");
    private static final Pattern SAVEDSEARCH_PATTERN = Pattern.compile("^[0-9a-z][0-9a-z_-]{0,62}[0-9a-z]$");
    private static final Pattern JOB_PATTERN = Pattern.compile("^[0-9a-zA-Z-_]{1,63}$");
    private static final Pattern CONFIG_PATTERN = Pattern.compile("^[0-9a-zA-Z][0-9a-zA-Z_-]{0,126}[0-9a-zA-Z]$");
    private static final Pattern MACHINE_GROUP_PATTERN = Pattern.compile("^[0-9a-zA-Z][0-9a-zA-Z_-]{0,126}[0-9a-zA-Z]$");
    private static final Pattern SHIPPER_PATTERN = Pattern.compile("^[0-9a-zA-Z][0-9a-zA-Z_-]{0,126}[0-9a-zA-Z]$");
    private static final Pattern RESOURCE_PATTERN = Pattern.compile("^[a-z][0-9a-z_.]{1,125}[0-9a-z]$");
    private static final Pattern RECORD_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9_:.-]{0,63}$");
    private static final Pattern ETL_JOB_PATTERN = Pattern.compile("^[0-9a-z][0-9a-z_-]{0,62}[0-9a-z]$");
    private static final int MAX_OFFSET = Integer.MAX_VALUE;

    public static void assertParameterNotNull(Object param, String paramName) throws LogException {
        if (param == null) {
            throw new LogException("InvalidParameter", paramName + " is null", "");
        }
    }

    public static void assertStringNotNullOrEmpty(String param, String paramName) throws LogException {
        CodingUtils.assertParameterNotNull(param, paramName);
        if (param.isEmpty()) {
            throw new LogException("InvalidParameter", paramName + " is empty", "");
        }
    }

    public static void validateDashboardName(String dashboardName) throws LogException {
        CodingUtils.assertParameterNotNull(dashboardName, "dashboardName");
        if (!DASHBOARD_PATTERN.matcher(dashboardName).matches()) {
            throw new LogException("InvalidParameter", "Invalid dashboard: " + dashboardName, "");
        }
    }

    public static void validateLogstore(String logstore) throws LogException {
        CodingUtils.assertParameterNotNull(logstore, "logstore");
        if (!LOGSTORE_PATTERN.matcher(logstore).matches()) {
            throw new LogException("InvalidParameter", "Invalid logstore: " + logstore, "");
        }
    }

    public static void validateMetastore(String metastore) throws LogException {
        CodingUtils.assertParameterNotNull(metastore, "metastore");
        if (!METASTORE_PATTERN.matcher(metastore).matches()) {
            throw new LogException("InvalidParameter", "Invalid metastore: " + metastore, "");
        }
    }

    public static void validateSavedSearch(String savedsearch) throws LogException {
        CodingUtils.assertParameterNotNull(savedsearch, "savedsearch");
        if (!SAVEDSEARCH_PATTERN.matcher(savedsearch).matches()) {
            throw new LogException("InvalidParameter", "Invalid savedsearch: " + savedsearch, "");
        }
    }

    public static void validateJob(String jobName) throws LogException {
        CodingUtils.assertParameterNotNull(jobName, "jobName");
        if (!JOB_PATTERN.matcher(jobName).matches()) {
            throw new LogException("InvalidParameter", "Invalid jobName: " + jobName, "");
        }
    }

    public static void validateProject(String project) throws LogException {
        CodingUtils.assertParameterNotNull(project, "project");
        if (!PROJECT_PATTERN.matcher(project).matches()) {
            throw new LogException("InvalidParameter", "Invalid project: " + project, "");
        }
    }

    public static void validateConsumerGroup(String consumerGroup) throws LogException {
        CodingUtils.assertParameterNotNull(consumerGroup, "consumerGroup");
        if (!CONSUMER_GROUP_PATTERN.matcher(consumerGroup).matches()) {
            throw new LogException("InvalidParameter", "Invalid consumerGroup: " + consumerGroup, "");
        }
    }

    public static void validateConfig(String config) throws LogException {
        CodingUtils.assertParameterNotNull(config, "config");
        if (!CONFIG_PATTERN.matcher(config).matches()) {
            throw new LogException("InvalidParameter", "Invalid configName: " + config, "");
        }
    }

    public static void validateMachineGroup(String machineGroup) throws LogException {
        CodingUtils.assertParameterNotNull(machineGroup, "machineGroup");
        if (!MACHINE_GROUP_PATTERN.matcher(machineGroup).matches()) {
            throw new LogException("InvalidParameter", "Invalid machineGroupName: " + machineGroup, "");
        }
    }

    public static void validateShipper(String shipperName) throws LogException {
        CodingUtils.assertParameterNotNull(shipperName, "shipperName");
        if (!SHIPPER_PATTERN.matcher(shipperName).matches()) {
            throw new LogException("InvalidParameter", "Invalid shipperName: " + shipperName, "");
        }
    }

    public static void validateResource(String resourceName) throws LogException {
        CodingUtils.assertParameterNotNull(resourceName, "resourceName");
        if (!RESOURCE_PATTERN.matcher(resourceName).matches()) {
            throw new LogException("InvalidParameter", "Invalid resourceName: " + resourceName, "");
        }
    }

    public static void validateRecordId(String recordId) throws LogException {
        CodingUtils.assertParameterNotNull(recordId, "recordId");
        if (!RECORD_ID_PATTERN.matcher(recordId).matches()) {
            throw new LogException("InvalidParameter", "Invalid recordId: " + recordId, "");
        }
    }

    public static void validateETLJob(String etlJobName) throws LogException {
        CodingUtils.assertParameterNotNull(etlJobName, "etlJobName");
        if (!ETL_JOB_PATTERN.matcher(etlJobName).matches()) {
            throw new LogException("InvalidParameter", "Invalid etlJobName: " + etlJobName, "");
        }
    }

    public static void validateOffset(long offset) throws LogException {
        CodingUtils.assertParameterNotNull(offset, "offset");
        if (offset > Integer.MAX_VALUE) {
            throw new LogException("InvalidParameter", "Up to 2147483647 numbers of logs are supported to search", "");
        }
    }
}

