/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.http.signer;

import com.aliyun.openservices.log.common.auth.Credentials;
import com.aliyun.openservices.log.http.client.HttpMethod;
import com.aliyun.openservices.log.http.signer.SlsSigner;
import com.aliyun.openservices.log.http.signer.SlsSignerBase;
import com.aliyun.openservices.log.http.utils.BinaryUtil;
import com.aliyun.openservices.log.http.utils.HttpUtil;
import com.aliyun.openservices.log.util.Args;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SlsV4Signer
extends SlsSignerBase
implements SlsSigner {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final Charset CHARSET_UTF_8 = Charset.forName("UTF-8");
    private static final List<String> DEFAULT_SIGNED_HEADERS = Arrays.asList("Content-Type".toLowerCase(), "Host".toLowerCase());
    private static final String ALGORITHM = "HmacSHA256";
    private static final Object LOCK = new Object();
    private static Mac macInstance;
    private static final String ISO8601_DATETIME_FORMAT = "yyyyMMdd'T'HHmmss'Z'";
    private static final String SEPARATOR_BACKSLASH = "/";
    private static final String SLS4_HMAC_SHA256 = "SLS4-HMAC-SHA256";
    private static final String SLS_PRODUCT_NAME = "sls";
    private static final String TERMINATOR = "aliyun_v4_request";
    private static final String SECRET_KEY_PREFIX = "aliyun_v4";
    private static final String NEW_LINE = "\n";
    private final String region;

    public SlsV4Signer(Credentials credentials, String region) {
        super(credentials);
        Args.check(region != null && !region.isEmpty(), "region must not be empty for v4 signature.");
        this.region = region;
    }

    private static DateFormat getIso8601DateTimeFormat() {
        SimpleDateFormat df = new SimpleDateFormat(ISO8601_DATETIME_FORMAT, Locale.US);
        df.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return df;
    }

    private String getDateTime(Date now) {
        return SlsV4Signer.getIso8601DateTimeFormat().format(now);
    }

    private String buildCanonicalRequest(String method, String resourcePath, Map<String, String> parameters, String canonicalHeaders, String signedHeaders, String hashedPayLoad) {
        StringBuilder canonicalString = new StringBuilder();
        canonicalString.append(method).append(NEW_LINE);
        canonicalString.append(resourcePath).append(NEW_LINE);
        if (parameters != null) {
            TreeMap<String, String> orderMap = new TreeMap<String, String>(parameters);
            String separator = "";
            for (Map.Entry<String, String> param : orderMap.entrySet()) {
                canonicalString.append(separator).append(param.getKey());
                String value = param.getValue();
                if (value != null && !value.isEmpty()) {
                    canonicalString.append("=").append(HttpUtil.percentEncode(value));
                }
                separator = "&";
            }
        }
        canonicalString.append(NEW_LINE);
        canonicalString.append(canonicalHeaders).append(NEW_LINE);
        canonicalString.append(signedHeaders).append(NEW_LINE);
        canonicalString.append(hashedPayLoad);
        return canonicalString.toString();
    }

    private String buildScope(String date) {
        return date + SEPARATOR_BACKSLASH + this.region + SEPARATOR_BACKSLASH + SLS_PRODUCT_NAME + SEPARATOR_BACKSLASH + TERMINATOR;
    }

    private String buildStringToSign(String canonicalString, String dateTime, String scope) {
        return "SLS4-HMAC-SHA256\n" + dateTime + NEW_LINE + scope + NEW_LINE + BinaryUtil.toHex(BinaryUtil.calculateSha256(canonicalString.getBytes(CHARSET_UTF_8)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Mac getMacInstance() {
        try {
            Mac mac;
            if (macInstance == null) {
                Object object = LOCK;
                synchronized (object) {
                    if (macInstance == null) {
                        macInstance = Mac.getInstance(ALGORITHM);
                    }
                }
            }
            try {
                mac = (Mac)macInstance.clone();
            }
            catch (CloneNotSupportedException e) {
                mac = Mac.getInstance(ALGORITHM);
            }
            return mac;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Unsupported algorithm: HmacSHA256", ex);
        }
    }

    private static byte[] buildSigningKey(HmacSHA256Hasher hasher, String secretAccessKey, String region, String date) {
        byte[] signingSecret = (SECRET_KEY_PREFIX + secretAccessKey).getBytes(CHARSET_UTF_8);
        byte[] signingDate = hasher.hash(signingSecret, date.getBytes(CHARSET_UTF_8));
        byte[] signingRegion = hasher.hash(signingDate, region.getBytes(CHARSET_UTF_8));
        byte[] signingService = hasher.hash(signingRegion, SLS_PRODUCT_NAME.getBytes(CHARSET_UTF_8));
        return hasher.hash(signingService, TERMINATOR.getBytes(CHARSET_UTF_8));
    }

    private static String buildAuthorization(String accessKeyId, String signature, String scope) {
        String credential = "Credential=" + accessKeyId + SEPARATOR_BACKSLASH + scope;
        String sign = ",Signature=" + signature;
        return "SLS4-HMAC-SHA256 " + credential + sign;
    }

    @Override
    public void sign(HttpMethod httpMethod, Map<String, String> headers, String resourceUri, Map<String, String> urlParams, byte[] body) {
        Date now = new Date();
        String dateTime = this.getDateTime(now);
        headers.put("Authorization", this.signRequest(headers, httpMethod, resourceUri, urlParams, body, dateTime));
    }

    public String signRequest(Map<String, String> headers, HttpMethod httpMethod, String resourceUri, Map<String, String> urlParams, byte[] body, String dateTime) {
        String contentSha256;
        if (body != null && body.length > 0) {
            headers.put("Content-Length", String.valueOf(body.length));
            contentSha256 = BinaryUtil.toHex(BinaryUtil.calculateSha256(body));
        } else {
            headers.put("Content-Length", "0");
            contentSha256 = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
        }
        headers.put("x-log-date", dateTime);
        headers.put("x-log-content-sha256", contentSha256);
        TreeMap canonicalHeaders = new TreeMap();
        StringBuilder signedHeaders = new StringBuilder();
        for (Map.Entry<String, String> header : headers.entrySet()) {
            String string = header.getKey().toLowerCase();
            if (!DEFAULT_SIGNED_HEADERS.contains(string) && !string.startsWith("x-log-") && !string.startsWith("x-acs-")) continue;
            canonicalHeaders.put(string, header.getValue());
        }
        StringBuilder headersToString = new StringBuilder();
        for (Map.Entry entry : canonicalHeaders.entrySet()) {
            if (signedHeaders.length() > 0) {
                signedHeaders.append(";");
            }
            String headerKey = (String)entry.getKey();
            signedHeaders.append(headerKey);
            headersToString.append(headerKey).append(":").append(HttpUtil.trim((String)entry.getValue())).append(NEW_LINE);
        }
        String signedHeadersStr = signedHeaders.toString();
        String string = this.buildCanonicalRequest(httpMethod.toString(), resourceUri, urlParams, headersToString.toString(), signedHeadersStr, contentSha256);
        String date = dateTime.substring(0, 8);
        String scope = this.buildScope(date);
        String stringToSign = this.buildStringToSign(string, dateTime, scope);
        Mac mac = SlsV4Signer.getMacInstance();
        HmacSHA256Hasher sha256Hasher = new HmacSHA256Hasher(mac);
        byte[] signingKey = SlsV4Signer.buildSigningKey(sha256Hasher, this.credentials.getAccessKeySecret(), this.region, date);
        byte[] result = sha256Hasher.hash(signingKey, stringToSign.getBytes(CHARSET_UTF_8));
        String signature = BinaryUtil.toHex(result);
        String authorization = SlsV4Signer.buildAuthorization(this.credentials.getAccessKeyId(), signature, scope);
        return authorization;
    }

    private static class HmacSHA256Hasher {
        private final Mac mac;

        public HmacSHA256Hasher(Mac mac) {
            this.mac = mac;
        }

        public byte[] hash(byte[] key, byte[] data) {
            try {
                this.mac.init(new SecretKeySpec(key, SlsV4Signer.ALGORITHM));
                return this.mac.doFinal(data);
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException("Unable to calculate the signature", e);
            }
        }
    }
}

