/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.mqtt.server.util;

import com.alibaba.mq.amqp.utils.UserUtils;
import com.alibaba.mqtt.server.util.Tools;
import com.rabbitmq.client.impl.CredentialsProvider;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunCredentialsProvider
implements CredentialsProvider {
    private static Logger logger = LoggerFactory.getLogger(AliyunCredentialsProvider.class);
    private final String accessKeyId;
    private final String accessKeySecret;
    private final String securityToken;
    private final String instanceId;
    private final long ts;

    public AliyunCredentialsProvider(String accessKeyId, String accessKeySecret, String instanceId, long ts) {
        this(accessKeyId, accessKeySecret, null, instanceId, ts);
    }

    public AliyunCredentialsProvider(String accessKeyId, String accessKeySecret, String securityToken, String instanceId, long ts) {
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.securityToken = securityToken;
        this.instanceId = instanceId;
        this.ts = ts;
    }

    public String getUsername() {
        if (StringUtils.isNotEmpty((CharSequence)this.securityToken)) {
            return UserUtils.getUserName((String)this.accessKeyId, (String)this.instanceId, (String)this.securityToken);
        }
        return UserUtils.getUserName((String)this.accessKeyId, (String)this.instanceId);
    }

    public String getPassword() {
        try {
            return Tools.macSignature(String.valueOf(this.ts), this.accessKeySecret);
        }
        catch (InvalidKeyException e) {
            logger.error("get password error! check your params, NoSuchAlgorithmException:" + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("get password error! check your params, invalidKeyException:" + e.getMessage());
        }
        return null;
    }
}

