/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.config.spring.beans.factory.annotation;

import com.alibaba.dubbo.config.annotation.Reference;
import com.alibaba.dubbo.config.spring.ReferenceBean;
import com.alibaba.dubbo.config.spring.ServiceBean;
import com.alibaba.dubbo.config.spring.beans.factory.annotation.AnnotationBeanNameBuilder;
import com.alibaba.dubbo.config.spring.beans.factory.annotation.AnnotationInjectedBeanPostProcessor;
import com.alibaba.dubbo.config.spring.beans.factory.annotation.ReferenceBeanBuilder;
import com.alibaba.dubbo.config.spring.context.event.ServiceBeanExportedEvent;
import com.alibaba.dubbo.config.spring.util.AnnotationUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.env.PropertyResolver;

public class ReferenceAnnotationBeanPostProcessor
extends AnnotationInjectedBeanPostProcessor<Reference>
implements ApplicationContextAware,
ApplicationListener {
    public static final String BEAN_NAME = "referenceAnnotationBeanPostProcessor";
    private static final int CACHE_SIZE = Integer.getInteger("referenceAnnotationBeanPostProcessor.cache.size", 32);
    private final ConcurrentMap<String, ReferenceBean<?>> referenceBeanCache = new ConcurrentHashMap(CACHE_SIZE);
    private final ConcurrentHashMap<String, ReferenceBeanInvocationHandler> localReferenceBeanInvocationHandlerCache = new ConcurrentHashMap(CACHE_SIZE);
    private final ConcurrentMap<InjectionMetadata.InjectedElement, ReferenceBean<?>> injectedFieldReferenceBeanCache = new ConcurrentHashMap(CACHE_SIZE);
    private final ConcurrentMap<InjectionMetadata.InjectedElement, ReferenceBean<?>> injectedMethodReferenceBeanCache = new ConcurrentHashMap(CACHE_SIZE);
    private ApplicationContext applicationContext;

    public Collection<ReferenceBean<?>> getReferenceBeans() {
        return this.referenceBeanCache.values();
    }

    public Map<InjectionMetadata.InjectedElement, ReferenceBean<?>> getInjectedFieldReferenceBeanMap() {
        return Collections.unmodifiableMap(this.injectedFieldReferenceBeanCache);
    }

    public Map<InjectionMetadata.InjectedElement, ReferenceBean<?>> getInjectedMethodReferenceBeanMap() {
        return Collections.unmodifiableMap(this.injectedMethodReferenceBeanCache);
    }

    @Override
    protected Object doGetInjectedBean(Reference reference, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) throws Exception {
        String referencedBeanName = this.buildReferencedBeanName(reference, injectedType);
        ReferenceBean referenceBean = this.buildReferenceBeanIfAbsent(referencedBeanName, reference, injectedType, this.getClassLoader());
        this.cacheInjectedReferenceBean(referenceBean, injectedElement);
        Object proxy = this.buildProxy(referencedBeanName, referenceBean, injectedType);
        return proxy;
    }

    private Object buildProxy(String referencedBeanName, ReferenceBean referenceBean, Class<?> injectedType) {
        InvocationHandler handler = this.buildInvocationHandler(referencedBeanName, referenceBean);
        Object proxy = Proxy.newProxyInstance(this.getClassLoader(), new Class[]{injectedType}, handler);
        return proxy;
    }

    private InvocationHandler buildInvocationHandler(String referencedBeanName, ReferenceBean referenceBean) {
        ReferenceBeanInvocationHandler handler = this.localReferenceBeanInvocationHandlerCache.get(referencedBeanName);
        if (handler == null) {
            handler = new ReferenceBeanInvocationHandler(referenceBean);
        }
        if (this.applicationContext.containsBean(referencedBeanName)) {
            this.localReferenceBeanInvocationHandlerCache.put(referencedBeanName, handler);
        } else {
            handler.init();
        }
        return handler;
    }

    @Override
    protected String buildInjectedObjectCacheKey(Reference reference, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) {
        String key = this.buildReferencedBeanName(reference, injectedType) + "#source=" + injectedElement.getMember() + "#attributes=" + AnnotationUtils.getAttributes((Annotation)reference, (PropertyResolver)this.getEnvironment(), true, new String[0]);
        return key;
    }

    private String buildReferencedBeanName(Reference reference, Class<?> injectedType) {
        AnnotationBeanNameBuilder builder = AnnotationBeanNameBuilder.create(reference, injectedType);
        builder.environment(this.getEnvironment());
        return this.getEnvironment().resolvePlaceholders(builder.build());
    }

    private ReferenceBean buildReferenceBeanIfAbsent(String referencedBeanName, Reference reference, Class<?> referencedType, ClassLoader classLoader) throws Exception {
        ReferenceBean referenceBean = (ReferenceBean)this.referenceBeanCache.get(referencedBeanName);
        if (referenceBean == null) {
            ReferenceBeanBuilder beanBuilder = (ReferenceBeanBuilder)ReferenceBeanBuilder.create(reference, classLoader, this.applicationContext).interfaceClass(referencedType);
            referenceBean = (ReferenceBean)beanBuilder.build();
            this.referenceBeanCache.put(referencedBeanName, referenceBean);
        }
        return referenceBean;
    }

    private void cacheInjectedReferenceBean(ReferenceBean referenceBean, InjectionMetadata.InjectedElement injectedElement) {
        if (injectedElement.getMember() instanceof Field) {
            this.injectedFieldReferenceBeanCache.put(injectedElement, referenceBean);
        } else if (injectedElement.getMember() instanceof Method) {
            this.injectedMethodReferenceBeanCache.put(injectedElement, referenceBean);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ServiceBeanExportedEvent) {
            this.onServiceBeanExportEvent((ServiceBeanExportedEvent)event);
        } else if (event instanceof ContextRefreshedEvent) {
            this.onContextRefreshedEvent((ContextRefreshedEvent)event);
        }
    }

    private void onServiceBeanExportEvent(ServiceBeanExportedEvent event) {
        ServiceBean serviceBean = event.getServiceBean();
        this.initReferenceBeanInvocationHandler(serviceBean);
    }

    private void initReferenceBeanInvocationHandler(ServiceBean serviceBean) {
        String serviceBeanName = serviceBean.getBeanName();
        ReferenceBeanInvocationHandler handler = this.localReferenceBeanInvocationHandlerCache.remove(serviceBeanName);
        if (handler != null) {
            handler.init();
        }
    }

    private void onContextRefreshedEvent(ContextRefreshedEvent event) {
    }

    @Override
    public void destroy() throws Exception {
        super.destroy();
        this.referenceBeanCache.clear();
        this.localReferenceBeanInvocationHandlerCache.clear();
        this.injectedFieldReferenceBeanCache.clear();
        this.injectedMethodReferenceBeanCache.clear();
    }

    private static class ReferenceBeanInvocationHandler
    implements InvocationHandler {
        private final ReferenceBean referenceBean;
        private Object bean;

        private ReferenceBeanInvocationHandler(ReferenceBean referenceBean) {
            this.referenceBean = referenceBean;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = null;
            try {
                if (this.bean == null) {
                    this.init();
                }
                result = method.invoke(this.bean, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            return result;
        }

        private void init() {
            this.bean = this.referenceBean.get();
        }
    }
}

