/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.discovery.autoconfigure;

import com.alibaba.boot.nacos.discovery.autoconfigure.AutoDeregisterException;
import com.alibaba.boot.nacos.discovery.autoconfigure.NacosDiscoveryAutoRegister;
import com.alibaba.boot.nacos.discovery.properties.NacosDiscoveryProperties;
import com.alibaba.boot.nacos.discovery.properties.Register;
import com.alibaba.nacos.api.annotation.NacosInjected;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.client.naming.utils.NetUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.server.WebServer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.stereotype.Component;

@Component
public class NacosDiscoveryAutoDeregister
implements ApplicationListener<ContextClosedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(NacosDiscoveryAutoRegister.class);
    @NacosInjected
    private NamingService namingService;
    private final NacosDiscoveryProperties discoveryProperties;
    private final WebServer webServer;
    @Value(value="${spring.application.name:spring.application.name}")
    private String applicationName;

    public NacosDiscoveryAutoDeregister(NacosDiscoveryProperties discoveryProperties, WebServer webServer) {
        this.discoveryProperties = discoveryProperties;
        this.webServer = webServer;
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        if (!this.discoveryProperties.isAutoRegister()) {
            return;
        }
        Register register = this.discoveryProperties.getRegister();
        if (StringUtils.isEmpty((CharSequence)register.getIp())) {
            register.setIp(NetUtils.localIP());
        }
        if (register.getPort() == 0) {
            register.setPort(this.webServer.getPort());
        }
        String serviceName = StringUtils.isEmpty((CharSequence)register.getServiceName()) ? this.applicationName : register.getServiceName();
        try {
            this.namingService.deregisterInstance(serviceName, register.getGroupName(), (Instance)register);
            logger.info("Finished auto deregister service : {}, ip : {}, port : {}", new Object[]{register.getServiceName(), register.getIp(), register.getPort()});
        }
        catch (NacosException e) {
            throw new AutoDeregisterException(e);
        }
    }
}

