/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.config.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class AttributeExtractTask
implements Callable<Map<String, String>> {
    private final String prefix;
    private final ConfigurableEnvironment environment;

    public AttributeExtractTask(String prefix, ConfigurableEnvironment environment) {
        this.prefix = prefix;
        this.environment = environment;
    }

    @Override
    public Map<String, String> call() throws Exception {
        LinkedList<Map<String, String>> defer = new LinkedList<Map<String, String>>();
        MutablePropertySources mutablePropertySources = this.environment.getPropertySources();
        for (PropertySource propertySource : mutablePropertySources) {
            this.calculate(propertySource.getSource(), defer);
        }
        HashMap<String, String> result = new HashMap<String, String>(32);
        Collections.reverse(defer);
        for (Map map : defer) {
            result.putAll(map);
        }
        return result;
    }

    private void calculate(Object source, List<Map<String, String>> defer) {
        if (source instanceof PropertySource) {
            this.calculate(((PropertySource)source).getSource(), defer);
        }
        if (source instanceof Map) {
            HashMap<String, String> map = new HashMap<String, String>(8);
            for (Object object : ((Map)source).entrySet()) {
                Map.Entry element = (Map.Entry)object;
                String key = String.valueOf(element.getKey());
                if (!key.startsWith(this.prefix)) continue;
                map.put(key, String.valueOf(element.getValue()));
            }
            if (!map.isEmpty()) {
                defer.add(map);
            }
        }
        if (source instanceof List || source instanceof Set) {
            Collection sources = (Collection)source;
            for (Object object : sources) {
                this.calculate(object, defer);
            }
        }
    }
}

