/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.config.util;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public class NacosPropertiesBuilder {
    public static Properties buildNacosProperties(Environment environment, String serverAddr, String namespaceId, String endpoint, String secretKey, String accessKey, String ramRoleName, String configLongPollTimeout, String configRetryTimeout, String maxRetry, boolean enableRemoteSyncConfig) {
        Properties properties = new Properties();
        if (StringUtils.isNotEmpty((CharSequence)serverAddr)) {
            properties.put("serverAddr", serverAddr);
        }
        if (StringUtils.isNotEmpty((CharSequence)namespaceId)) {
            properties.put("namespace", namespaceId);
        }
        if (StringUtils.isNotEmpty((CharSequence)endpoint)) {
            properties.put("endpoint", endpoint);
        }
        if (StringUtils.isNotEmpty((CharSequence)secretKey)) {
            properties.put("secretKey", secretKey);
        }
        if (StringUtils.isNotEmpty((CharSequence)accessKey)) {
            properties.put("accessKey", accessKey);
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{ramRoleName})) {
            properties.put("ramRoleName", ramRoleName);
        }
        if (StringUtils.isNotEmpty((CharSequence)configLongPollTimeout)) {
            properties.put("configLongPollTimeout", configLongPollTimeout);
        }
        if (StringUtils.isNotEmpty((CharSequence)configRetryTimeout)) {
            properties.put("configRetryTime", configRetryTimeout);
        }
        if (StringUtils.isNotEmpty((CharSequence)maxRetry)) {
            properties.put("maxRetry", maxRetry);
        }
        properties.put("enableRemoteSyncConfig", String.valueOf(enableRemoteSyncConfig));
        return properties;
    }

    public static void merge(Properties targetProperties, Properties sourceProperties) {
        if (CollectionUtils.isEmpty((Map)sourceProperties)) {
            return;
        }
        for (Map.Entry<Object, Object> entry : sourceProperties.entrySet()) {
            String propertyName = (String)entry.getKey();
            if (targetProperties.containsKey(propertyName)) continue;
            String propertyValue = (String)entry.getValue();
            targetProperties.setProperty(propertyName, propertyValue);
        }
    }
}

