/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.config.support;

import com.alibaba.nacos.spring.util.parse.DefaultYamlConfigParse;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.yaml.snakeyaml.Yaml;

public class MultiProfilesYamlConfigParseSupport
extends DefaultYamlConfigParse
implements EnvironmentPostProcessor {
    private static final String SPRING_PROFILES = "spring.profiles";
    private static String[] profileArray = new String[0];

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String[] profiles = environment.getActiveProfiles();
        if (profiles.length == 0) {
            profiles = environment.getDefaultProfiles();
        }
        if (profileArray.length == 0) {
            profileArray = profiles;
        }
    }

    public Map<String, Object> parse(String configText) {
        AtomicReference result = new AtomicReference();
        MultiProfilesYamlConfigParseSupport.process(map -> {
            if (result.get() == null) {
                result.set(map);
            } else {
                this.setFromOtherBlock(result, map);
            }
        }, (Yaml)MultiProfilesYamlConfigParseSupport.createYaml(), (String)configText);
        return (Map)result.get();
    }

    private void setFromOtherBlock(AtomicReference<Map<String, Object>> result, Map<String, Object> map) {
        if (map.get(SPRING_PROFILES) == null) {
            result.get().putAll(map);
            return;
        }
        for (String profile : profileArray) {
            if (!profile.equals(map.get(SPRING_PROFILES))) continue;
            result.get().putAll(map);
        }
    }

    static void setProfileArray(String[] profiles) {
        profileArray = profiles;
    }
}

